/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.v1;

import java.util.Map;
import org.neo4j.driver.internal.security.InternalAuthToken;
import org.neo4j.driver.v1.AuthToken;
import org.neo4j.driver.v1.Values;

public class AuthTokens {
    public static AuthToken basic(String username, String password) {
        return new InternalAuthToken(Values.parameters("scheme", "basic", "principal", username, "credentials", password).asMap(Values.ofValue()));
    }

    public static AuthToken basic(String username, String password, String realm) {
        return new InternalAuthToken(Values.parameters("scheme", "basic", "principal", username, "credentials", password, "realm", realm).asMap(Values.ofValue()));
    }

    public static AuthToken custom(String principal, String credentials, String realm, String scheme) {
        return new InternalAuthToken(Values.parameters("scheme", scheme, "principal", principal, "credentials", credentials, "realm", realm).asMap(Values.ofValue()));
    }

    public static AuthToken custom(String principal, String credentials, String realm, String scheme, Map<String, Object> parameters) {
        return new InternalAuthToken(Values.parameters("scheme", scheme, "principal", principal, "credentials", credentials, "realm", realm, "parameters", parameters).asMap(Values.ofValue()));
    }

    public static AuthToken none() {
        return new InternalAuthToken(Values.parameters("scheme", "none").asMap(Values.ofValue()));
    }
}

