/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal;

import java.util.List;
import org.neo4j.driver.internal.ClusteredErrorHandler;
import org.neo4j.driver.internal.net.BoltServerAddress;
import org.neo4j.driver.v1.Record;
import org.neo4j.driver.v1.StatementResult;
import org.neo4j.driver.v1.exceptions.ClientException;
import org.neo4j.driver.v1.exceptions.ConnectionFailureException;
import org.neo4j.driver.v1.exceptions.NoSuchRecordException;
import org.neo4j.driver.v1.exceptions.SessionExpiredException;
import org.neo4j.driver.v1.summary.ResultSummary;
import org.neo4j.driver.v1.util.Function;

public class ClusteredStatementResult
implements StatementResult {
    private final StatementResult delegate;
    private final BoltServerAddress address;
    private final ClusteredErrorHandler onError;

    ClusteredStatementResult(StatementResult delegate, BoltServerAddress address, ClusteredErrorHandler onError) {
        this.delegate = delegate;
        this.address = address;
        this.onError = onError;
    }

    @Override
    public List<String> keys() {
        try {
            return this.delegate.keys();
        }
        catch (ConnectionFailureException e) {
            throw this.sessionExpired(e);
        }
        catch (ClientException e) {
            if (this.isFailedToWrite(e)) {
                throw this.failedWrite();
            }
            throw e;
        }
    }

    @Override
    public boolean hasNext() {
        try {
            return this.delegate.hasNext();
        }
        catch (ConnectionFailureException e) {
            throw this.sessionExpired(e);
        }
        catch (ClientException e) {
            if (this.isFailedToWrite(e)) {
                throw this.failedWrite();
            }
            throw e;
        }
    }

    @Override
    public Record next() {
        try {
            return this.delegate.next();
        }
        catch (ConnectionFailureException e) {
            throw this.sessionExpired(e);
        }
        catch (ClientException e) {
            if (this.isFailedToWrite(e)) {
                throw this.failedWrite();
            }
            throw e;
        }
    }

    @Override
    public Record single() throws NoSuchRecordException {
        try {
            return this.delegate.single();
        }
        catch (ConnectionFailureException e) {
            throw this.sessionExpired(e);
        }
        catch (ClientException e) {
            if (this.isFailedToWrite(e)) {
                throw this.failedWrite();
            }
            throw e;
        }
    }

    @Override
    public Record peek() {
        try {
            return this.delegate.peek();
        }
        catch (ConnectionFailureException e) {
            throw this.sessionExpired(e);
        }
        catch (ClientException e) {
            if (this.isFailedToWrite(e)) {
                throw this.failedWrite();
            }
            throw e;
        }
    }

    @Override
    public List<Record> list() {
        try {
            return this.delegate.list();
        }
        catch (ConnectionFailureException e) {
            throw this.sessionExpired(e);
        }
        catch (ClientException e) {
            if (this.isFailedToWrite(e)) {
                throw this.failedWrite();
            }
            throw e;
        }
    }

    @Override
    public <T> List<T> list(Function<Record, T> mapFunction) {
        try {
            return this.delegate.list(mapFunction);
        }
        catch (ConnectionFailureException e) {
            throw this.sessionExpired(e);
        }
        catch (ClientException e) {
            if (this.isFailedToWrite(e)) {
                throw this.failedWrite();
            }
            throw e;
        }
    }

    @Override
    public void remove() {
        throw new ClientException("Removing records from a result is not supported.");
    }

    @Override
    public ResultSummary consume() {
        try {
            return this.delegate.consume();
        }
        catch (ConnectionFailureException e) {
            throw this.sessionExpired(e);
        }
        catch (ClientException e) {
            if (this.isFailedToWrite(e)) {
                throw this.failedWrite();
            }
            throw e;
        }
    }

    private SessionExpiredException sessionExpired(ConnectionFailureException e) {
        this.onError.onConnectionFailure(this.address);
        return new SessionExpiredException(String.format("Server at %s is no longer available", this.address.toString()), e);
    }

    private SessionExpiredException failedWrite() {
        this.onError.onWriteFailure(this.address);
        return new SessionExpiredException(String.format("Server at %s no longer accepts writes", this.address.toString()));
    }

    private boolean isFailedToWrite(ClientException e) {
        return e.code().equals("Neo.ClientError.Cluster.NotALeader");
    }
}

