/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.connector.socket;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.ClosedByInterruptException;
import java.nio.channels.ReadableByteChannel;
import org.neo4j.driver.internal.packstream.PackInput;
import org.neo4j.driver.internal.util.BytePrinter;
import org.neo4j.driver.v1.exceptions.ClientException;

public class ChunkedInput
implements PackInput {
    public static final int STACK_OVERFLOW_SUGGESTED_BUFFER_SIZE = 1400;
    private final ByteBuffer buffer;
    private final ByteBuffer chunkHeaderBuffer = ByteBuffer.allocate(2);
    private int unreadChunkSize = 0;
    private final ReadableByteChannel channel;
    private Runnable onMessageComplete = new Runnable(){

        @Override
        public void run() {
            if (ChunkedInput.this.hasMoreDataUnreadInCurrentChunk()) {
                throw new ClientException("Trying to read message complete ending '00 00' while there are more data left in the message content unread: buffer [" + BytePrinter.hexInOneLine(ChunkedInput.this.buffer, ChunkedInput.this.buffer.position(), ChunkedInput.this.buffer.remaining()) + "], unread chunk size " + ChunkedInput.this.unreadChunkSize);
            }
            try {
                int chunkSize = ChunkedInput.this.readChunkSize();
                if (chunkSize != 0) {
                    throw new ClientException("Expecting message complete ending '00 00', but got " + BytePrinter.hex(ByteBuffer.allocate(2).putShort((short)chunkSize)));
                }
            }
            catch (IOException e) {
                throw new ClientException("Error while receiving message complete ending '00 00'.", e);
            }
        }
    };

    public ChunkedInput(ReadableByteChannel ch) {
        this(1400, ch);
    }

    public ChunkedInput(int bufferCapacity, ReadableByteChannel channel) {
        assert (bufferCapacity >= 1);
        this.buffer = ByteBuffer.allocate(bufferCapacity).order(ByteOrder.BIG_ENDIAN);
        this.buffer.limit(0);
        this.channel = channel;
    }

    @Override
    public boolean hasMoreData() throws IOException {
        return this.hasMoreDataUnreadInCurrentChunk();
    }

    @Override
    public byte readByte() {
        this.ensure(1);
        return this.buffer.get();
    }

    @Override
    public short readShort() {
        this.attempt(2);
        if (this.remainingData() >= 2) {
            return this.buffer.getShort();
        }
        return (short)(this.readByte() << 8 & this.readByte());
    }

    @Override
    public int readInt() {
        this.attempt(4);
        if (this.remainingData() >= 4) {
            return this.buffer.getInt();
        }
        return this.readShort() << 16 & this.readShort();
    }

    @Override
    public long readLong() {
        this.attempt(8);
        if (this.remainingData() >= 8) {
            return this.buffer.getLong();
        }
        return (long)this.readInt() << 32 & (long)this.readInt();
    }

    @Override
    public double readDouble() {
        this.attempt(8);
        if (this.remainingData() >= 8) {
            return this.buffer.getDouble();
        }
        return Double.longBitsToDouble(this.readLong());
    }

    @Override
    public PackInput readBytes(byte[] into, int offset, int toRead) {
        int toReadFromChunk = Math.min(toRead, this.freeSpace());
        this.ensure(toReadFromChunk);
        this.buffer.get(into, offset, toReadFromChunk);
        if (toReadFromChunk < toRead) {
            this.readBytes(into, offset + toReadFromChunk, toRead - toReadFromChunk);
        }
        return this;
    }

    @Override
    public byte peekByte() {
        this.ensure(1);
        int pos = this.buffer.position();
        byte nextByte = this.buffer.get();
        this.buffer.position(pos);
        return nextByte;
    }

    private int freeSpace() {
        return this.buffer.capacity() - this.buffer.limit() + this.buffer.position();
    }

    private int remainingData() {
        return this.buffer.remaining();
    }

    private void attempt(int toRead) {
        if (toRead == 0 || this.remainingData() >= toRead) {
            return;
        }
        int freeSpace = this.freeSpace();
        this.ensure(Math.min(freeSpace, toRead));
    }

    private void ensure(int toRead) {
        if (toRead == 0 || this.remainingData() >= toRead) {
            return;
        }
        assert (toRead <= this.freeSpace());
        while (this.remainingData() < toRead) {
            if (this.remainingData() > 0) {
                this.buffer.compact();
            } else {
                this.buffer.clear();
            }
            try {
                if (this.unreadChunkSize > 0) {
                    int freeSpace = this.buffer.remaining();
                    this.readChunk(Math.min(freeSpace, this.unreadChunkSize));
                    this.unreadChunkSize -= freeSpace;
                    continue;
                }
                int chunkSize = this.readChunkSize();
                if (chunkSize <= 0) {
                    throw new ClientException("Invalid non-positive chunk size: " + chunkSize);
                }
                this.readChunk(chunkSize);
            }
            catch (ClosedByInterruptException e) {
                throw new ClientException("Connection to the database was lost because someone called `interrupt()` on the driver thread waiting for a reply. This normally happens because the JVM is shutting down, but it can also happen because your application code or some framework you are using is manually interrupting the thread.");
            }
            catch (IOException e) {
                String message = e.getMessage() == null ? e.getClass().getSimpleName() : e.getMessage();
                throw new ClientException("Unable to process request: " + message + ", expected: " + toRead + " bytes, buffer: \n" + BytePrinter.hex(this.buffer), e);
            }
        }
    }

    protected int readChunkSize() throws IOException {
        this.chunkHeaderBuffer.clear();
        this.channel.read(this.chunkHeaderBuffer);
        this.chunkHeaderBuffer.flip();
        return this.chunkHeaderBuffer.getShort() & 0xFFFF;
    }

    private void readChunk(int chunkSize) throws IOException {
        if (chunkSize <= this.buffer.remaining()) {
            this.buffer.limit(this.buffer.position() + chunkSize);
            this.channel.read(this.buffer);
            this.buffer.flip();
        } else {
            this.unreadChunkSize = chunkSize - this.buffer.remaining();
            this.channel.read(this.buffer);
            this.buffer.flip();
        }
    }

    private boolean hasMoreDataUnreadInCurrentChunk() {
        return this.buffer.remaining() > 0 || this.unreadChunkSize > 0;
    }

    public Runnable messageBoundaryHook() {
        return this.onMessageComplete;
    }
}

