/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.v1;

import java.io.File;
import java.util.logging.Level;
import org.neo4j.driver.internal.logging.JULogging;
import org.neo4j.driver.internal.spi.Logging;
import org.neo4j.driver.v1.util.Immutable;

@Immutable
public class Config {
    private final Logging logging;
    private final int connectionPoolSize;
    private final int maxIdleConnectionPoolSize;
    private final long idleTimeBeforeConnectionTest;
    private final EncryptionLevel encryptionLevel;
    private final TrustStrategy trustStrategy;

    private Config(ConfigBuilder builder) {
        this.logging = builder.logging;
        this.connectionPoolSize = builder.connectionPoolSize;
        this.maxIdleConnectionPoolSize = builder.maxIdleConnectionPoolSize;
        this.idleTimeBeforeConnectionTest = builder.idleTimeBeforeConnectionTest;
        this.encryptionLevel = builder.encruptionLevel;
        this.trustStrategy = builder.trustStrategy;
    }

    public Logging logging() {
        return this.logging;
    }

    @Deprecated
    public int connectionPoolSize() {
        return this.maxIdleConnectionPoolSize;
    }

    public int maxIdleConnectionPoolSize() {
        return this.maxIdleConnectionPoolSize;
    }

    public long idleTimeBeforeConnectionTest() {
        return this.idleTimeBeforeConnectionTest;
    }

    public EncryptionLevel encryptionLevel() {
        return this.encryptionLevel;
    }

    public TrustStrategy trustStrategy() {
        return this.trustStrategy;
    }

    public static ConfigBuilder build() {
        return new ConfigBuilder();
    }

    public static Config defaultConfig() {
        return Config.build().toConfig();
    }

    public static class TrustStrategy {
        private final Strategy strategy;
        private final File certFile;

        private TrustStrategy(Strategy strategy, File certFile) {
            this.strategy = strategy;
            this.certFile = certFile;
        }

        public Strategy strategy() {
            return this.strategy;
        }

        public File certFile() {
            return this.certFile;
        }

        public static TrustStrategy trustSignedBy(File certFile) {
            return new TrustStrategy(Strategy.TRUST_SIGNED_CERTIFICATES, certFile);
        }

        public static TrustStrategy trustOnFirstUse(File knownHostsFile) {
            return new TrustStrategy(Strategy.TRUST_ON_FIRST_USE, knownHostsFile);
        }

        public static enum Strategy {
            TRUST_ON_FIRST_USE,
            TRUST_SIGNED_CERTIFICATES;

        }
    }

    public static enum EncryptionLevel {
        NONE,
        REQUIRED;

    }

    public static class ConfigBuilder {
        private Logging logging = new JULogging(Level.INFO);
        private int connectionPoolSize = 50;
        private int maxIdleConnectionPoolSize = 10;
        private long idleTimeBeforeConnectionTest = 200L;
        private EncryptionLevel encruptionLevel = EncryptionLevel.REQUIRED;
        private TrustStrategy trustStrategy = TrustStrategy.trustOnFirstUse(new File(System.getProperty("user.home"), ".neo4j" + File.separator + "known_hosts"));

        private ConfigBuilder() {
        }

        public ConfigBuilder withLogging(Logging logging) {
            this.logging = logging;
            return this;
        }

        @Deprecated
        public ConfigBuilder withMaxSessions(int size) {
            this.connectionPoolSize = size;
            return this;
        }

        public ConfigBuilder withMaxIdleSessions(int size) {
            this.maxIdleConnectionPoolSize = size;
            return this;
        }

        public ConfigBuilder withSessionLivenessCheckTimeout(long timeout) {
            this.idleTimeBeforeConnectionTest = timeout;
            return this;
        }

        public ConfigBuilder withEncryptionLevel(EncryptionLevel level) {
            this.encruptionLevel = level;
            return this;
        }

        public ConfigBuilder withTrustStrategy(TrustStrategy trustStrategy) {
            this.trustStrategy = trustStrategy;
            return this;
        }

        public Config toConfig() {
            return new Config(this);
        }
    }
}

