/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.packstream;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.WritableByteChannel;
import org.neo4j.driver.internal.packstream.PackOutput;

public class BufferedChannelOutput
implements PackOutput {
    private final ByteBuffer buffer;
    private WritableByteChannel channel;

    public BufferedChannelOutput(int bufferSize) {
        this.buffer = ByteBuffer.allocateDirect(bufferSize).order(ByteOrder.BIG_ENDIAN);
    }

    public BufferedChannelOutput(WritableByteChannel channel) {
        this(channel, 1024);
    }

    public BufferedChannelOutput(WritableByteChannel channel, int bufferSize) {
        this(bufferSize);
        this.reset(channel);
    }

    public void reset(WritableByteChannel channel) {
        this.channel = channel;
    }

    @Override
    public BufferedChannelOutput flush() throws IOException {
        this.buffer.flip();
        do {
            this.channel.write(this.buffer);
        } while (this.buffer.remaining() > 0);
        this.buffer.clear();
        return this;
    }

    @Override
    public PackOutput writeBytes(byte[] data, int offset, int length) throws IOException {
        int amountToWrite;
        for (int index = 0; index < length; index += amountToWrite) {
            if (this.buffer.remaining() == 0) {
                this.flush();
            }
            amountToWrite = Math.min(this.buffer.remaining(), length - index);
            this.buffer.put(data, offset + index, amountToWrite);
        }
        return this;
    }

    @Override
    public PackOutput writeByte(byte value) throws IOException {
        this.ensure(1);
        this.buffer.put(value);
        return this;
    }

    @Override
    public PackOutput writeShort(short value) throws IOException {
        this.ensure(2);
        this.buffer.putShort(value);
        return this;
    }

    @Override
    public PackOutput writeInt(int value) throws IOException {
        this.ensure(4);
        this.buffer.putInt(value);
        return this;
    }

    @Override
    public PackOutput writeLong(long value) throws IOException {
        this.ensure(8);
        this.buffer.putLong(value);
        return this;
    }

    @Override
    public PackOutput writeDouble(double value) throws IOException {
        this.ensure(8);
        this.buffer.putDouble(value);
        return this;
    }

    private void ensure(int size) throws IOException {
        if (this.buffer.remaining() < size) {
            this.flush();
        }
    }
}

