/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.connector.socket;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.ClosedByInterruptException;
import java.nio.channels.ReadableByteChannel;
import org.neo4j.driver.internal.packstream.PackInput;
import org.neo4j.driver.internal.util.BytePrinter;
import org.neo4j.driver.v1.exceptions.ClientException;

public class BufferingChunkedInput
implements PackInput {
    private static final int STACK_OVERFLOW_SUGGESTED_BUFFER_SIZE = 1400;
    private final ByteBuffer buffer;
    private final ByteBuffer scratchBuffer;
    private final ReadableByteChannel channel;
    private State state;
    private int remainingChunkSize = 0;
    private Runnable onMessageComplete = new Runnable(){

        @Override
        public void run() {
            if (BufferingChunkedInput.this.hasMoreDataUnreadInCurrentChunk()) {
                throw new ClientException("Trying to read message complete ending '00 00' while there are more data left in the message content unread: buffer [" + BytePrinter.hexInOneLine(BufferingChunkedInput.this.buffer, BufferingChunkedInput.this.buffer.position(), BufferingChunkedInput.this.buffer.remaining()) + "], unread chunk size " + BufferingChunkedInput.this.remainingChunkSize);
            }
            try {
                BufferingChunkedInput.this.state.readChunkSize(BufferingChunkedInput.this);
                if (BufferingChunkedInput.this.remainingChunkSize != 0) {
                    throw new ClientException("Expecting message complete ending '00 00', but got " + BytePrinter.hex(ByteBuffer.allocate(2).putShort((short)BufferingChunkedInput.this.remainingChunkSize)));
                }
            }
            catch (IOException e) {
                throw new ClientException("Error while receiving message complete ending '00 00'.", e);
            }
        }
    };

    public BufferingChunkedInput(ReadableByteChannel ch) {
        this(ch, 1400);
    }

    public BufferingChunkedInput(ReadableByteChannel channel, int bufferCapacity) {
        assert (bufferCapacity >= 1);
        this.buffer = ByteBuffer.allocateDirect(bufferCapacity).order(ByteOrder.BIG_ENDIAN);
        this.buffer.limit(0);
        this.scratchBuffer = ByteBuffer.allocateDirect(8).order(ByteOrder.BIG_ENDIAN);
        this.channel = channel;
        this.state = State.AWAITING_CHUNK;
    }

    @Override
    public boolean hasMoreData() throws IOException {
        return this.hasMoreDataUnreadInCurrentChunk();
    }

    @Override
    public byte readByte() throws IOException {
        this.fillScratchBuffer(1);
        return this.scratchBuffer.get();
    }

    @Override
    public short readShort() throws IOException {
        this.fillScratchBuffer(2);
        return this.scratchBuffer.getShort();
    }

    @Override
    public int readInt() throws IOException {
        this.fillScratchBuffer(4);
        return this.scratchBuffer.getInt();
    }

    @Override
    public long readLong() throws IOException {
        this.fillScratchBuffer(8);
        return this.scratchBuffer.getLong();
    }

    @Override
    public double readDouble() throws IOException {
        this.fillScratchBuffer(8);
        return this.scratchBuffer.getDouble();
    }

    @Override
    public PackInput readBytes(byte[] into, int offset, int toRead) throws IOException {
        int left = toRead;
        while (left > 0) {
            int bufferSize = Math.min(8, left);
            this.fillScratchBuffer(bufferSize);
            this.scratchBuffer.get(into, offset, bufferSize);
            left -= bufferSize;
            offset += bufferSize;
        }
        return this;
    }

    @Override
    public byte peekByte() throws IOException {
        this.state = this.state.peekByte(this);
        return this.buffer.get(this.buffer.position());
    }

    private boolean hasMoreDataUnreadInCurrentChunk() {
        return this.remainingChunkSize > 0;
    }

    public Runnable messageBoundaryHook() {
        return this.onMessageComplete;
    }

    private void fillScratchBuffer(int bytesToRead) throws IOException {
        assert (bytesToRead <= this.scratchBuffer.capacity());
        this.scratchBuffer.clear();
        this.scratchBuffer.limit(bytesToRead);
        this.state = this.state.read(this);
        this.scratchBuffer.flip();
    }

    private static enum State {
        AWAITING_CHUNK{

            @Override
            public State readChunkSize(BufferingChunkedInput ctx) throws IOException {
                if (ctx.buffer.remaining() == 0) {
                    State.readNextPacket(ctx.channel, ctx.buffer);
                    return AWAITING_CHUNK.readChunkSize(ctx);
                }
                if (ctx.buffer.remaining() >= 2) {
                    ctx.remainingChunkSize = ctx.buffer.getShort() & 0xFFFF;
                    return IN_CHUNK;
                }
                byte partialChunkSize = ctx.buffer.get();
                ctx.remainingChunkSize = partialChunkSize << 8;
                return IN_HEADER.readChunkSize(ctx);
            }

            @Override
            public State read(BufferingChunkedInput ctx) throws IOException {
                return this.readChunkSize(ctx).read(ctx);
            }

            @Override
            public State peekByte(BufferingChunkedInput ctx) throws IOException {
                return this.readChunkSize(ctx).peekByte(ctx);
            }
        }
        ,
        IN_CHUNK{

            @Override
            public State readChunkSize(BufferingChunkedInput ctx) throws IOException {
                if (ctx.remainingChunkSize == 0) {
                    return AWAITING_CHUNK.readChunkSize(ctx);
                }
                throw new IllegalStateException("Chunk size has already been read");
            }

            @Override
            public State read(BufferingChunkedInput ctx) throws IOException {
                if (ctx.remainingChunkSize == 0) {
                    return AWAITING_CHUNK.read(ctx);
                }
                if (ctx.buffer.remaining() < ctx.scratchBuffer.remaining()) {
                    int bytesToRead = Math.min(ctx.buffer.remaining(), ctx.remainingChunkSize);
                    State.copyBytes(ctx.buffer, ctx.scratchBuffer, bytesToRead);
                    ctx.remainingChunkSize -= bytesToRead;
                    State.readNextPacket(ctx.channel, ctx.buffer);
                    return IN_CHUNK.read(ctx);
                }
                int bytesToRead = Math.min(ctx.scratchBuffer.remaining(), ctx.remainingChunkSize);
                State.copyBytes(ctx.buffer, ctx.scratchBuffer, bytesToRead);
                ctx.remainingChunkSize -= bytesToRead;
                if (ctx.scratchBuffer.remaining() == 0) {
                    return IN_CHUNK;
                }
                return AWAITING_CHUNK.read(ctx);
            }

            @Override
            public State peekByte(BufferingChunkedInput ctx) throws IOException {
                if (ctx.remainingChunkSize == 0) {
                    return AWAITING_CHUNK.peekByte(ctx);
                }
                if (ctx.buffer.remaining() == 0) {
                    State.readNextPacket(ctx.channel, ctx.buffer);
                    return IN_CHUNK.peekByte(ctx);
                }
                return IN_CHUNK;
            }
        }
        ,
        IN_HEADER{

            @Override
            public State readChunkSize(BufferingChunkedInput ctx) throws IOException {
                if (ctx.buffer.remaining() >= 1) {
                    byte partialChunkSize = ctx.buffer.get();
                    ctx.remainingChunkSize = (ctx.remainingChunkSize | partialChunkSize) & 0xFFFF;
                    return IN_CHUNK;
                }
                State.readNextPacket(ctx.channel, ctx.buffer);
                return IN_HEADER.readChunkSize(ctx);
            }

            @Override
            public State read(BufferingChunkedInput ctx) throws IOException {
                throw new IllegalStateException("Cannot read data while in progress of reading header");
            }

            @Override
            public State peekByte(BufferingChunkedInput ctx) throws IOException {
                throw new IllegalStateException("Cannot read data while in progress of reading header");
            }
        };


        public abstract State readChunkSize(BufferingChunkedInput var1) throws IOException;

        public abstract State read(BufferingChunkedInput var1) throws IOException;

        public abstract State peekByte(BufferingChunkedInput var1) throws IOException;

        private static void readNextPacket(ReadableByteChannel channel, ByteBuffer buffer) throws IOException {
            try {
                buffer.clear();
                channel.read(buffer);
                buffer.flip();
            }
            catch (ClosedByInterruptException e) {
                throw new ClientException("Connection to the database was lost because someone called `interrupt()` on the driver thread waiting for a reply. This normally happens because the JVM is shutting down, but it can also happen because your application code or some framework you are using is manually interrupting the thread.");
            }
            catch (IOException e) {
                String message = e.getMessage() == null ? e.getClass().getSimpleName() : e.getMessage();
                throw new ClientException("Unable to process request: " + message + " buffer: \n" + BytePrinter.hex(buffer), e);
            }
        }

        private static void copyBytes(ByteBuffer from, ByteBuffer to, int bytesToRead) {
            ByteBuffer temporaryBuffer = from.duplicate();
            temporaryBuffer.limit(temporaryBuffer.position() + bytesToRead);
            to.put(temporaryBuffer);
            from.position(from.position() + bytesToRead);
        }
    }
}

