/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal;

import java.util.Collections;
import java.util.Map;
import org.neo4j.driver.internal.InternalStatementResult;
import org.neo4j.driver.internal.spi.Connection;
import org.neo4j.driver.internal.spi.StreamCollector;
import org.neo4j.driver.internal.types.InternalTypeSystem;
import org.neo4j.driver.v1.Record;
import org.neo4j.driver.v1.Statement;
import org.neo4j.driver.v1.StatementResult;
import org.neo4j.driver.v1.Transaction;
import org.neo4j.driver.v1.Value;
import org.neo4j.driver.v1.Values;
import org.neo4j.driver.v1.exceptions.ClientException;
import org.neo4j.driver.v1.exceptions.Neo4jException;
import org.neo4j.driver.v1.types.TypeSystem;

public class InternalTransaction
implements Transaction {
    private final Runnable cleanup;
    private final Connection conn;
    private State state = State.ACTIVE;

    public InternalTransaction(Connection conn, Runnable cleanup) {
        this.conn = conn;
        this.cleanup = cleanup;
        conn.run("BEGIN", Collections.emptyMap(), StreamCollector.NO_OP);
        conn.discardAll();
    }

    @Override
    public void success() {
        if (this.state == State.ACTIVE) {
            this.state = State.MARKED_SUCCESS;
        }
    }

    @Override
    public void failure() {
        if (this.state == State.ACTIVE || this.state == State.MARKED_SUCCESS) {
            this.state = State.MARKED_FAILED;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        try {
            if (this.conn != null && this.conn.isOpen()) {
                if (this.state == State.MARKED_SUCCESS) {
                    this.conn.run("COMMIT", Collections.emptyMap(), StreamCollector.NO_OP);
                    this.conn.discardAll();
                    this.conn.sync();
                    this.state = State.SUCCEEDED;
                } else if (this.state == State.MARKED_FAILED || this.state == State.ACTIVE) {
                    this.conn.run("ROLLBACK", Collections.emptyMap(), StreamCollector.NO_OP);
                    this.conn.discardAll();
                    this.conn.sync();
                    this.state = State.ROLLED_BACK;
                }
            }
        }
        finally {
            this.cleanup.run();
        }
    }

    @Override
    public StatementResult run(String statementText, Value statementParameters) {
        return this.run(new Statement(statementText, statementParameters));
    }

    @Override
    public StatementResult run(String statementText) {
        return this.run(statementText, Values.EmptyMap);
    }

    @Override
    public StatementResult run(String statementText, Map<String, Object> statementParameters) {
        return this.run(statementText, Values.value(statementParameters));
    }

    @Override
    public StatementResult run(String statementTemplate, Record statementParameters) {
        return this.run(statementTemplate, statementParameters.asMap());
    }

    @Override
    public StatementResult run(Statement statement) {
        this.ensureNotFailed();
        try {
            InternalStatementResult cursor = new InternalStatementResult(this.conn, statement);
            this.conn.run(statement.text(), statement.parameters().asMap(Values.ofValue()), cursor.runResponseCollector());
            this.conn.pullAll(cursor.pullAllResponseCollector());
            this.conn.flush();
            return cursor;
        }
        catch (Neo4jException e) {
            this.state = State.FAILED;
            throw e;
        }
    }

    @Override
    public boolean isOpen() {
        return this.state == State.ACTIVE;
    }

    private void ensureNotFailed() {
        if (this.state == State.FAILED || this.state == State.MARKED_FAILED || this.state == State.ROLLED_BACK) {
            throw new ClientException("Cannot run more statements in this transaction, because previous statements in the transaction has failed and the transaction has been rolled back. Please start a new transaction to run another statement.");
        }
    }

    @Override
    public TypeSystem typeSystem() {
        return InternalTypeSystem.TYPE_SYSTEM;
    }

    public void markAsRolledBack() {
        this.state = State.ROLLED_BACK;
    }

    private static enum State {
        ACTIVE,
        MARKED_SUCCESS,
        MARKED_FAILED,
        FAILED,
        SUCCEEDED,
        ROLLED_BACK;

    }
}

