/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import org.neo4j.driver.internal.InternalRecord;
import org.neo4j.driver.internal.InternalRecordAccessor;
import org.neo4j.driver.internal.spi.Connection;
import org.neo4j.driver.internal.spi.StreamCollector;
import org.neo4j.driver.internal.summary.SummaryBuilder;
import org.neo4j.driver.v1.Function;
import org.neo4j.driver.v1.Notification;
import org.neo4j.driver.v1.Plan;
import org.neo4j.driver.v1.ProfiledPlan;
import org.neo4j.driver.v1.Record;
import org.neo4j.driver.v1.RecordAccessor;
import org.neo4j.driver.v1.Records;
import org.neo4j.driver.v1.ResultCursor;
import org.neo4j.driver.v1.ResultSummary;
import org.neo4j.driver.v1.Statement;
import org.neo4j.driver.v1.StatementType;
import org.neo4j.driver.v1.Transaction;
import org.neo4j.driver.v1.UpdateStatistics;
import org.neo4j.driver.v1.Value;
import org.neo4j.driver.v1.exceptions.ClientException;
import org.neo4j.driver.v1.exceptions.Neo4jException;
import org.neo4j.driver.v1.exceptions.NoSuchRecordException;

public class InternalResultCursor
extends InternalRecordAccessor
implements ResultCursor {
    private final Connection connection;
    private final Transaction transaction;
    private final StreamCollector runResponseCollector;
    private final StreamCollector pullAllResponseCollector;
    private final Queue<Record> recordBuffer = new LinkedList<Record>();
    private List<String> keys = null;
    private ResultSummary summary = null;
    private boolean open = true;
    private Record current = null;
    private long position = -1L;
    private long limit = -1L;
    private boolean done = false;

    public InternalResultCursor(Connection connection, Transaction tx, String statement, Map<String, Value> parameters) {
        this.connection = connection;
        this.transaction = tx;
        this.runResponseCollector = this.newRunResponseCollector();
        this.pullAllResponseCollector = this.newPullAllResponseCollector(new Statement(statement, parameters));
    }

    private StreamCollector newRunResponseCollector() {
        return new StreamCollector(){

            @Override
            public void keys(String[] names) {
                InternalResultCursor.this.keys = Arrays.asList(names);
            }

            @Override
            public void record(Value[] fields) {
            }

            @Override
            public void statementType(StatementType type) {
            }

            @Override
            public void statementStatistics(UpdateStatistics statistics) {
            }

            @Override
            public void plan(Plan plan) {
            }

            @Override
            public void profile(ProfiledPlan plan) {
            }

            @Override
            public void notifications(List<Notification> notifications) {
            }

            @Override
            public void done() {
                if (InternalResultCursor.this.keys == null) {
                    InternalResultCursor.this.keys = new ArrayList();
                }
            }
        };
    }

    private StreamCollector newPullAllResponseCollector(Statement statement) {
        final SummaryBuilder summaryBuilder = new SummaryBuilder(statement);
        return new StreamCollector(){

            @Override
            public void keys(String[] names) {
            }

            @Override
            public void record(Value[] fields) {
                InternalResultCursor.this.recordBuffer.add(new InternalRecord(InternalResultCursor.this.keys, fields));
            }

            @Override
            public void statementType(StatementType type) {
                summaryBuilder.statementType(type);
            }

            @Override
            public void statementStatistics(UpdateStatistics statistics) {
                summaryBuilder.statementStatistics(statistics);
            }

            @Override
            public void plan(Plan plan) {
                summaryBuilder.plan(plan);
            }

            @Override
            public void profile(ProfiledPlan plan) {
                summaryBuilder.profile(plan);
            }

            @Override
            public void notifications(List<Notification> notifications) {
                summaryBuilder.notifications(notifications);
            }

            @Override
            public void done() {
                InternalResultCursor.this.summary = summaryBuilder.build();
                InternalResultCursor.this.done = true;
            }
        };
    }

    StreamCollector runResponseCollector() {
        return this.runResponseCollector;
    }

    StreamCollector pullAllResponseCollector() {
        return this.pullAllResponseCollector;
    }

    private void receiveOne() {
        try {
            this.connection.receiveOne();
        }
        catch (Neo4jException ex) {
            if (this.transaction != null) {
                this.transaction.defunct();
            }
            throw ex;
        }
    }

    @Override
    public boolean isOpen() {
        return this.open;
    }

    @Override
    public Value get(int index) {
        return this.record().get(index);
    }

    @Override
    public Value get(String key) {
        return this.record().get(key);
    }

    @Override
    public boolean containsKey(String key) {
        return this.keys.contains(key);
    }

    @Override
    public int index(String key) {
        return this.record().index(key);
    }

    @Override
    public List<String> keys() {
        while (this.keys == null && !this.done) {
            this.receiveOne();
        }
        return this.keys;
    }

    @Override
    public int size() {
        return this.keys.size();
    }

    @Override
    public Record record() {
        if (this.current != null) {
            return this.current;
        }
        throw new NoSuchRecordException("In order to access the fields of a record in a result, you must first call next() to point the result to the next record in the result stream.");
    }

    @Override
    public long position() {
        this.assertOpen();
        return this.position;
    }

    @Override
    public boolean atEnd() {
        this.assertOpen();
        if (!this.recordBuffer.isEmpty()) {
            return false;
        }
        if (this.done) {
            return true;
        }
        while (this.recordBuffer.isEmpty() && !this.done) {
            this.receiveOne();
        }
        return this.recordBuffer.isEmpty() && this.done;
    }

    @Override
    public boolean next() {
        this.assertOpen();
        Record nextRecord = this.recordBuffer.poll();
        if (nextRecord != null) {
            this.current = nextRecord;
            ++this.position;
            if (this.position == this.limit) {
                this.discard();
            }
            return true;
        }
        if (this.done) {
            return false;
        }
        while (this.recordBuffer.isEmpty() && !this.done) {
            this.receiveOne();
        }
        return this.next();
    }

    @Override
    public long skip(long elements) {
        if (elements < 0L) {
            throw new ClientException("Cannot skip negative number of elements");
        }
        int skipped = 0;
        while ((long)skipped < elements && this.next()) {
            ++skipped;
        }
        return skipped;
    }

    @Override
    public long limit(long records) {
        if (records < 0L) {
            throw new ClientException("Cannot limit negative number of elements");
        }
        if (records == 0L) {
            this.limit = this.position;
            this.discard();
        } else {
            this.limit = records + this.position;
        }
        return this.limit;
    }

    @Override
    public Record first() {
        if (this.position() >= 1L) {
            throw new NoSuchRecordException("Cannot retrieve the first record, because this result cursor has been moved already. Please ensure you are not calling `first` multiple times, or are mixing it with calls to `next`, `single`, `list` or any other method that changes the position of the cursor.");
        }
        if (this.position == 0L) {
            return this.record();
        }
        if (!this.next()) {
            throw new NoSuchRecordException("Cannot retrieve the first record, because this result is empty.");
        }
        return this.record();
    }

    @Override
    public Value first(String fieldName) throws NoSuchRecordException {
        return this.first().get(fieldName);
    }

    @Override
    public Value first(int index) throws NoSuchRecordException {
        return this.first().get(index);
    }

    @Override
    public Record single() {
        Record first = this.first();
        if (!this.atEnd()) {
            throw new NoSuchRecordException("Expected a result with a single record, but this result contains at least one more. Ensure your query returns only one record, or use `first` instead of `single` if you do not care about the number of records in the result.");
        }
        return first;
    }

    @Override
    public Value single(String fieldName) throws NoSuchRecordException {
        return this.single().get(fieldName);
    }

    @Override
    public Value single(int index) throws NoSuchRecordException {
        return this.single().get(index);
    }

    @Override
    public Record peek() {
        this.assertOpen();
        Record nextRecord = this.recordBuffer.peek();
        if (nextRecord != null) {
            return nextRecord;
        }
        if (this.done) {
            return null;
        }
        while (this.recordBuffer.isEmpty() && !this.done) {
            this.receiveOne();
        }
        return this.peek();
    }

    @Override
    public List<Record> list() {
        return this.list(Records.recordAsIs());
    }

    @Override
    public <T> List<T> list(Function<RecordAccessor, T> mapFunction) {
        if (this.isEmpty()) {
            this.assertOpen();
            return Collections.emptyList();
        }
        if (this.position == 0L || this.position == -1L && this.next()) {
            ArrayList<T> result = new ArrayList<T>();
            do {
                result.add(mapFunction.apply(this));
            } while (this.next());
            this.discard();
            return result;
        }
        throw new ClientException(String.format("Can't retain records when cursor is not pointing at the first record (currently at position %d)", this.position));
    }

    @Override
    public ResultSummary summarize() {
        while (this.next()) {
        }
        return this.summary;
    }

    @Override
    public void close() {
        if (!this.open) {
            throw new ClientException("Already closed");
        }
        this.discard();
        this.open = false;
    }

    private void assertOpen() {
        if (!this.open) {
            throw new ClientException("Cursor already closed");
        }
    }

    private boolean isEmpty() {
        return this.position == -1L && this.recordBuffer.isEmpty() && this.done;
    }

    private void discard() {
        this.assertOpen();
        this.recordBuffer.clear();
        while (!this.done) {
            this.receiveOne();
        }
    }
}

