/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.pool;

import java.util.Map;
import org.neo4j.driver.internal.spi.Connection;
import org.neo4j.driver.internal.spi.StreamCollector;
import org.neo4j.driver.internal.util.Consumer;
import org.neo4j.driver.v1.Value;
import org.neo4j.driver.v1.exceptions.Neo4jException;

public class PooledConnection
implements Connection {
    private Connection delegate;
    private Consumer<PooledConnection> release;
    private boolean unrecoverableErrorsOccurred = false;

    public PooledConnection(Connection delegate, Consumer<PooledConnection> release) {
        this.delegate = delegate;
        this.release = release;
    }

    @Override
    public void init(String clientName) {
        try {
            this.delegate.init(clientName);
        }
        catch (RuntimeException e) {
            this.onDelegateException(e);
        }
    }

    @Override
    public void run(String statement, Map<String, Value> parameters, StreamCollector collector) {
        try {
            this.delegate.run(statement, parameters, collector);
        }
        catch (RuntimeException e) {
            this.onDelegateException(e);
        }
    }

    @Override
    public void discardAll() {
        try {
            this.delegate.discardAll();
        }
        catch (RuntimeException e) {
            this.onDelegateException(e);
        }
    }

    @Override
    public void pullAll(StreamCollector collector) {
        try {
            this.delegate.pullAll(collector);
        }
        catch (RuntimeException e) {
            this.onDelegateException(e);
        }
    }

    @Override
    public void reset(StreamCollector collector) {
        try {
            this.delegate.reset(collector);
        }
        catch (RuntimeException e) {
            this.onDelegateException(e);
        }
    }

    @Override
    public void sync() {
        try {
            this.delegate.sync();
        }
        catch (RuntimeException e) {
            this.onDelegateException(e);
        }
    }

    @Override
    public void close() {
        this.reset(StreamCollector.NO_OP);
        this.release.accept(this);
    }

    @Override
    public boolean isOpen() {
        return this.delegate.isOpen();
    }

    public boolean hasUnrecoverableErrors() {
        return this.unrecoverableErrorsOccurred;
    }

    public void dispose() {
        this.delegate.close();
    }

    private void onDelegateException(RuntimeException e) {
        if (!this.isClientOrTransientError(e) || this.isProtocolViolationError(e)) {
            this.unrecoverableErrorsOccurred = true;
        }
        throw e;
    }

    private boolean isProtocolViolationError(RuntimeException e) {
        return e instanceof Neo4jException && ((Neo4jException)e).neo4jErrorCode().startsWith("Neo.ClientError.Request");
    }

    private boolean isClientOrTransientError(RuntimeException e) {
        return e instanceof Neo4jException && (((Neo4jException)e).neo4jErrorCode().contains("ClientError") || ((Neo4jException)e).neo4jErrorCode().contains("TransientError"));
    }
}

