/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.neo4j.driver.internal.InternalRecordAccessor;
import org.neo4j.driver.internal.PeekingIterator;
import org.neo4j.driver.v1.Function;
import org.neo4j.driver.v1.Record;
import org.neo4j.driver.v1.RecordAccessor;
import org.neo4j.driver.v1.Records;
import org.neo4j.driver.v1.ResultCursor;
import org.neo4j.driver.v1.ResultSummary;
import org.neo4j.driver.v1.Value;
import org.neo4j.driver.v1.exceptions.ClientException;
import org.neo4j.driver.v1.exceptions.NoSuchRecordException;

public class InternalResultCursor
extends InternalRecordAccessor
implements ResultCursor {
    private final List<String> keys;
    private final PeekingIterator<Record> iter;
    private final ResultSummary summary;
    private boolean open = true;
    private Record current = null;
    private long position = -1L;
    private long limit = -1L;

    public InternalResultCursor(List<String> keys, List<Record> body, ResultSummary summary) {
        this.keys = keys;
        this.iter = new PeekingIterator<Record>(body.iterator());
        this.summary = summary;
    }

    @Override
    public boolean isOpen() {
        return this.open;
    }

    @Override
    public Value get(int index) {
        return this.record().get(index);
    }

    @Override
    public Value get(String key) {
        return this.record().get(key);
    }

    @Override
    public boolean containsKey(String key) {
        return this.keys.contains(key);
    }

    @Override
    public int index(String key) {
        return this.record().index(key);
    }

    @Override
    public List<String> keys() {
        return this.keys;
    }

    @Override
    public int size() {
        return this.keys.size();
    }

    @Override
    public Record record() {
        if (this.current != null) {
            return this.current;
        }
        throw new NoSuchRecordException("In order to access the fields of a record in a result, you must first call next() to point the result to the next record in the result stream.");
    }

    @Override
    public long position() {
        this.assertOpen();
        return this.position;
    }

    @Override
    public boolean atEnd() {
        this.assertOpen();
        return !this.iter.hasNext();
    }

    @Override
    public boolean next() {
        this.assertOpen();
        if (this.iter.hasNext()) {
            this.current = this.iter.next();
            ++this.position;
            if (this.position == this.limit) {
                this.discard();
            }
            return true;
        }
        return false;
    }

    @Override
    public long skip(long elements) {
        if (elements < 0L) {
            throw new ClientException("Cannot skip negative number of elements");
        }
        int skipped = 0;
        while ((long)skipped < elements && this.next()) {
            ++skipped;
        }
        return skipped;
    }

    @Override
    public long limit(long records) {
        if (records < 0L) {
            throw new ClientException("Cannot limit negative number of elements");
        }
        if (records == 0L) {
            this.limit = this.position;
            this.discard();
        } else {
            this.limit = records + this.position;
        }
        return this.limit;
    }

    @Override
    public Record first() {
        if (this.position() > 0L) {
            throw new NoSuchRecordException("Cannot retrieve the first record, because this result cursor has been moved already. Please ensure you are not calling `first` multiple times, or are mixing it with calls to `next`, `single`, `list` or any other method that changes the position of the cursor.");
        }
        if (this.position == 0L) {
            return this.record();
        }
        if (!this.next()) {
            throw new NoSuchRecordException("Cannot retrieve the first record, because this result is empty.");
        }
        return this.record();
    }

    @Override
    public Record single() {
        Record first = this.first();
        if (this.iter.hasNext()) {
            throw new NoSuchRecordException("Expected a result with a single record, but this result contains at least one more. Ensure your query returns only one record, or use `first` instead of `single` if you do not care about the number of records in the result.");
        }
        return first;
    }

    @Override
    public Record peek() {
        return this.iter.peek();
    }

    @Override
    public List<Record> list() {
        return this.list(Records.recordAsIs());
    }

    @Override
    public <T> List<T> list(Function<RecordAccessor, T> mapFunction) {
        if (this.isEmpty()) {
            this.assertOpen();
            return Collections.emptyList();
        }
        if (this.position == 0L || this.position == -1L && this.next()) {
            ArrayList<T> result = new ArrayList<T>();
            do {
                result.add(mapFunction.apply(this));
            } while (this.next());
            this.discard();
            return result;
        }
        throw new ClientException(String.format("Can't retain records when cursor is not pointing at the first record (currently at position %d)", this.position));
    }

    @Override
    public ResultSummary summarize() {
        while (this.next()) {
        }
        this.discard();
        return this.summary;
    }

    @Override
    public void close() {
        if (!this.open) {
            throw new ClientException("Already closed");
        }
        this.discard();
        this.open = false;
    }

    private void assertOpen() {
        if (!this.open) {
            throw new ClientException("Cursor already closed");
        }
    }

    private boolean isEmpty() {
        return this.position == -1L && !this.iter.hasNext();
    }

    private void discard() {
        this.iter.discard();
    }
}

