/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.connector.socket;

import java.io.IOException;
import java.net.SocketTimeoutException;
import java.util.LinkedList;
import java.util.Map;
import org.neo4j.driver.internal.connector.socket.LoggingResponseHandler;
import org.neo4j.driver.internal.connector.socket.SocketClient;
import org.neo4j.driver.internal.connector.socket.SocketResponseHandler;
import org.neo4j.driver.internal.messaging.AckFailureMessage;
import org.neo4j.driver.internal.messaging.DiscardAllMessage;
import org.neo4j.driver.internal.messaging.InitMessage;
import org.neo4j.driver.internal.messaging.Message;
import org.neo4j.driver.internal.messaging.PullAllMessage;
import org.neo4j.driver.internal.messaging.RunMessage;
import org.neo4j.driver.internal.spi.Connection;
import org.neo4j.driver.internal.spi.Logger;
import org.neo4j.driver.internal.spi.StreamCollector;
import org.neo4j.driver.v1.Config;
import org.neo4j.driver.v1.Value;
import org.neo4j.driver.v1.exceptions.ClientException;

public class SocketConnection
implements Connection {
    private final Logger logger;
    private int requestCounter = 0;
    private final LinkedList<Message> pendingMessages = new LinkedList();
    private final SocketResponseHandler responseHandler;
    private final SocketClient socket;

    public SocketConnection(String host, int port, Config config) {
        this.logger = config.logging().getLog(this.getClass().getName());
        this.responseHandler = this.logger.isDebugEnabled() ? new LoggingResponseHandler(this.logger) : new SocketResponseHandler();
        this.socket = new SocketClient(host, port, config, this.logger);
        this.socket.start();
    }

    @Override
    public void init(String clientName) {
        this.queueMessage(new InitMessage(clientName));
    }

    @Override
    public void run(String statement, Map<String, Value> parameters, StreamCollector collector) {
        int messageId = this.queueMessage(new RunMessage(statement, parameters));
        if (collector != null) {
            this.responseHandler.registerResultCollector(messageId, collector);
        }
    }

    @Override
    public void discardAll() {
        this.queueMessage(DiscardAllMessage.DISCARD_ALL);
    }

    @Override
    public void pullAll(StreamCollector collector) {
        int messageId = this.queueMessage(PullAllMessage.PULL_ALL);
        this.responseHandler.registerResultCollector(messageId, collector);
    }

    @Override
    public void sync() {
        if (this.pendingMessages.size() == 0) {
            return;
        }
        try {
            this.socket.send(this.pendingMessages, this.responseHandler);
            this.requestCounter = 0;
            this.pendingMessages.clear();
            if (this.responseHandler.serverFailureOccurred()) {
                this.queueMessage(new AckFailureMessage());
                throw this.responseHandler.serverFailure();
            }
        }
        catch (IOException e) {
            this.requestCounter = 0;
            this.pendingMessages.clear();
            String message = e.getMessage();
            if (message == null) {
                throw new ClientException("Unable to read response from server: " + e.getClass().getSimpleName(), e);
            }
            if (e instanceof SocketTimeoutException) {
                throw new ClientException("Server did not reply within the network timeout limit.", e);
            }
            throw new ClientException("Unable to read response from server: " + message, e);
        }
        finally {
            this.responseHandler.clear();
        }
    }

    private int queueMessage(Message msg) {
        int messageId = this.nextRequestId();
        this.pendingMessages.add(msg);
        this.logger.debug("C: %s", msg);
        return messageId;
    }

    @Override
    public void close() {
        this.socket.stop();
    }

    private int nextRequestId() {
        return this.requestCounter++;
    }
}

