/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.neo4j.driver.internal.Identities;
import org.neo4j.driver.internal.InternalEntity;
import org.neo4j.driver.internal.value.NodeValue;
import org.neo4j.driver.v1.Identity;
import org.neo4j.driver.v1.Node;
import org.neo4j.driver.v1.Value;

public class InternalNode
extends InternalEntity
implements Node {
    private final Collection<String> labels;

    public InternalNode(long id) {
        this(id, Collections.emptyList(), Collections.emptyMap());
    }

    public InternalNode(long id, Collection<String> labels, Map<String, Value> properties) {
        this(Identities.identity(id), labels, properties);
    }

    public InternalNode(Identity identity, Collection<String> labels, Map<String, Value> properties) {
        super(identity, properties);
        this.labels = labels;
    }

    public Collection<String> labels() {
        return this.labels;
    }

    @Override
    public boolean hasLabel(String label) {
        return this.labels.contains(label);
    }

    @Override
    public Value asValue() {
        return new NodeValue(this);
    }

    @Override
    public String toString() {
        return String.format("node<%s>", this.identity());
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        InternalNode that = (InternalNode)o;
        return !(this.labels == null ? that.labels != null : !this.labels.equals(that.labels));
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.labels != null ? this.labels.hashCode() : 0);
        return result;
    }
}

