/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.summary;

import java.util.List;
import java.util.Map;
import org.neo4j.driver.Function;
import org.neo4j.driver.ProfiledPlan;
import org.neo4j.driver.Value;
import org.neo4j.driver.internal.summary.SimplePlan;

public class SimpleProfiledPlan
extends SimplePlan<ProfiledPlan>
implements ProfiledPlan {
    private final long dbHits;
    private final long records;
    public static final SimplePlan.PlanCreator<ProfiledPlan> PROFILED_PLAN = new SimplePlan.PlanCreator<ProfiledPlan>(){

        @Override
        public ProfiledPlan create(String operatorType, Map<String, Value> arguments, List<String> identifiers, List<ProfiledPlan> children, Value originalPlanValue) {
            return new SimpleProfiledPlan(operatorType, arguments, identifiers, children, originalPlanValue.get("dbHits").javaLong(), originalPlanValue.get("rows").javaLong());
        }
    };
    public static final Function<Value, ProfiledPlan> PROFILED_PLAN_FROM_VALUE = new SimplePlan.Converter<ProfiledPlan>(PROFILED_PLAN);

    protected SimpleProfiledPlan(String operatorType, Map<String, Value> arguments, List<String> identifiers, List<ProfiledPlan> children, long dbHits, long records) {
        super(operatorType, arguments, identifiers, children);
        this.dbHits = dbHits;
        this.records = records;
    }

    @Override
    public long dbHits() {
        return this.dbHits;
    }

    @Override
    public long records() {
        return this.records;
    }
}

