/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal;

import java.util.Map;
import org.neo4j.driver.Result;
import org.neo4j.driver.Session;
import org.neo4j.driver.Statement;
import org.neo4j.driver.Transaction;
import org.neo4j.driver.Value;
import org.neo4j.driver.exceptions.ClientException;
import org.neo4j.driver.internal.ParameterSupport;
import org.neo4j.driver.internal.StandardTransaction;
import org.neo4j.driver.internal.spi.Connection;
import org.neo4j.driver.internal.summary.ResultBuilder;

public class StandardSession
implements Session {
    private final Connection connection;
    private final Runnable txCleanup = new Runnable(){

        @Override
        public void run() {
            StandardSession.this.currentTransaction = null;
        }
    };
    private Transaction currentTransaction;
    private boolean isOpen = true;

    public StandardSession(Connection connection) {
        this.connection = connection;
    }

    @Override
    public Result run(String statementText, Map<String, Value> parameters) {
        this.ensureNoOpenTransaction();
        ResultBuilder resultBuilder = new ResultBuilder(statementText, parameters);
        this.connection.run(statementText, parameters, resultBuilder);
        this.connection.pullAll(resultBuilder);
        this.connection.sync();
        return resultBuilder.build();
    }

    @Override
    public Result run(String statementText) {
        return this.run(statementText, ParameterSupport.NO_PARAMETERS);
    }

    @Override
    public Result run(Statement statement) {
        return this.run(statement.text(), statement.parameters());
    }

    @Override
    public boolean isOpen() {
        return this.isOpen;
    }

    @Override
    public void close() {
        if (!this.isOpen) {
            throw new ClientException("This session has already been closed.");
        }
        this.isOpen = false;
        if (this.currentTransaction != null) {
            try {
                this.currentTransaction.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        this.connection.close();
    }

    @Override
    public Transaction newTransaction() {
        this.ensureNoOpenTransaction();
        this.currentTransaction = new StandardTransaction(this.connection, this.txCleanup);
        return this.currentTransaction;
    }

    private void ensureNoOpenTransaction() {
        if (this.currentTransaction != null) {
            throw new ClientException("Please close the currently open transaction object before running more statements/transactions in the current session.");
        }
    }
}

