/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.neo4j.driver.Identity;
import org.neo4j.driver.Node;
import org.neo4j.driver.Value;
import org.neo4j.driver.internal.Identities;
import org.neo4j.driver.internal.SimpleEntity;

public class SimpleNode
extends SimpleEntity
implements Node {
    private final Collection<String> labels;

    public SimpleNode(long id) {
        this(id, Collections.emptyList(), Collections.emptyMap());
    }

    public SimpleNode(long id, Collection<String> labels, Map<String, Value> properties) {
        this(Identities.identity(id), labels, properties);
    }

    public SimpleNode(Identity identity, Collection<String> labels, Map<String, Value> properties) {
        super(identity, properties);
        this.labels = labels;
    }

    public Collection<String> labels() {
        return this.labels;
    }

    @Override
    public String toString() {
        return "node<" + this.identity() + '>';
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SimpleNode that = (SimpleNode)o;
        return !(this.labels == null ? that.labels != null : !this.labels.equals(that.labels));
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.labels != null ? this.labels.hashCode() : 0);
        return result;
    }
}

