/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shell.parameter;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.neo4j.cypher.internal.ast.factory.ASTFactory;
import org.neo4j.cypher.internal.literal.interpreter.LiteralInterpreter;
import org.neo4j.cypher.internal.parser.javacc.CharStream;
import org.neo4j.cypher.internal.parser.javacc.Cypher;
import org.neo4j.cypher.internal.parser.javacc.CypherCharStream;
import org.neo4j.shell.TransactionHandler;
import org.neo4j.shell.exception.CommandException;
import org.neo4j.shell.exception.ParameterException;
import org.neo4j.shell.log.Logger;
import org.neo4j.shell.parameter.ParameterService;
import org.neo4j.shell.prettyprint.CypherVariablesFormatter;
import org.neo4j.values.storable.Value;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
class ShellParameterService
implements ParameterService {
    private static final Logger log = Logger.create();
    private final Map<String, ParameterService.Parameter> parameters = new HashMap<String, ParameterService.Parameter>(0);
    private final Map<String, Object> parameterValues = new HashMap<String, Object>(0);
    private final ParameterService.ParameterParser parser = new ShellParameterParser();
    private final ParameterService.ParameterEvaluator evaluator;

    ShellParameterService(TransactionHandler db) {
        this.evaluator = new ShellParameterEvaluator(db);
    }

    @Override
    public Map<String, ParameterService.Parameter> parameters() {
        return this.parameters;
    }

    @Override
    public Map<String, Object> parameterValues() {
        return this.parameterValues;
    }

    @Override
    public void setParameter(ParameterService.Parameter parameter) {
        this.parameters.put(parameter.name(), parameter);
        this.parameterValues.put(parameter.name(), parameter.value());
    }

    @Override
    public ParameterService.Parameter evaluate(ParameterService.RawParameter parameter) throws CommandException {
        return this.evaluator.evaluate(parameter);
    }

    @Override
    public ParameterService.RawParameter parse(String input) throws ParameterService.ParameterParsingException {
        return this.parser.parse(input);
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static class ShellParameterParser
    implements ParameterService.ParameterParser {
        private final List<Pattern> patterns = List.of(Pattern.compile("^\\s*(?<key>[\\p{L}_][\\p{L}0-9_]*)\\s*=>\\s*(?<value>.+)$"), Pattern.compile("^\\s*(?<key>[\\p{L}_][\\p{L}0-9_]*):?\\s+(?<value>.+)$"), Pattern.compile("^\\s*(?<key>(`([^`])*`)+?)\\s*=>\\s*(?<value>.+)$"), Pattern.compile("^\\s*(?<key>(`([^`])*`)+?):?\\s+(?<value>.+)$"));
        private final Pattern invalidPattern = Pattern.compile("^\\s*(?<key>[\\p{L}_][\\p{L}0-9_]*):\\s*=>\\s*(?<value>.+)$");

        @Override
        public ParameterService.RawParameter parse(String input) throws ParameterService.ParameterParsingException {
            return this.doParse(ShellParameterParser.stripTrailingSemicolon(input));
        }

        private ParameterService.RawParameter doParse(String input) throws ParameterService.ParameterParsingException {
            if (this.invalidPattern.matcher(input).matches()) {
                throw new ParameterService.ParameterParsingException();
            }
            return this.patterns.stream().map(p -> p.matcher(input)).filter(Matcher::matches).findFirst().map(m -> new ParameterService.RawParameter(CypherVariablesFormatter.unescapedCypherVariable(m.group("key")), m.group("value"))).filter(p -> !p.name().isBlank()).orElseThrow(ParameterService.ParameterParsingException::new);
        }

        private static String stripTrailingSemicolon(String input) {
            return input.endsWith(";") ? StringUtils.stripEnd((String)input, (String)";") : input;
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    private class ShellParameterEvaluator
    implements ParameterService.ParameterEvaluator {
        private final LiteralInterpreter interpreter = new LiteralInterpreter();
        private final TransactionHandler db;

        private ShellParameterEvaluator(TransactionHandler db) {
            this.db = db;
        }

        @Override
        public ParameterService.Parameter evaluate(ParameterService.RawParameter parameter) throws CommandException {
            return this.evaluateOffline(parameter).or(() -> this.evaluateOnline(parameter)).map(v -> new ParameterService.Parameter(parameter.name(), parameter.expression(), v)).orElseThrow(() -> this.failedToEvaluate(parameter));
        }

        private CommandException failedToEvaluate(ParameterService.RawParameter parameter) {
            return new CommandException("Failed to evaluate parameter " + parameter.name() + ": " + parameter.expression());
        }

        private Optional<Object> evaluateOffline(ParameterService.RawParameter parameter) {
            Object value;
            try {
                value = new Cypher((ASTFactory)this.interpreter, ParameterException.FACTORY, (CharStream)new CypherCharStream(parameter.expression())).Expression();
            }
            catch (Exception e) {
                log.warn("Failed to evaluate expression " + parameter.expression() + " locally", e);
                return Optional.empty();
            }
            if (value instanceof Value) {
                Value neo4jValue = (Value)value;
                value = neo4jValue.asObject();
            }
            return Optional.ofNullable(value);
        }

        private Optional<Object> evaluateOnline(ParameterService.RawParameter parameter) {
            try {
                String query = "RETURN " + parameter.expression() + " AS `result`;";
                return this.db.runCypher(query, ShellParameterService.this.parameterValues(), TransactionHandler.TransactionType.USER_TRANSPILED).map(r -> r.iterate().next().get("result").asObject());
            }
            catch (Exception e) {
                log.error("Failed to evaluate expression " + parameter.expression() + " online", e);
                return Optional.empty();
            }
        }
    }
}

