/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shell.cli;

import java.net.URI;
import java.nio.file.Path;
import java.util.List;
import java.util.Optional;
import java.util.logging.Handler;
import org.neo4j.shell.ConnectionConfig;
import org.neo4j.shell.Historian;
import org.neo4j.shell.cli.Encryption;
import org.neo4j.shell.cli.FailBehavior;
import org.neo4j.shell.cli.Format;
import org.neo4j.shell.parameter.ParameterService;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class CliArgs {
    static final String DEFAULT_SCHEME = "neo4j";
    static final String DEFAULT_HOST = "localhost";
    static final int DEFAULT_PORT = 7687;
    static final int DEFAULT_NUM_SAMPLE_ROWS = 1000;
    private URI uri;
    private String username = "";
    private Optional<String> impersonatedUser = Optional.empty();
    private String password = "";
    private String databaseName = "";
    private FailBehavior failBehavior = FailBehavior.FAIL_FAST;
    private Format format = Format.AUTO;
    private Optional<String> cypher = Optional.empty();
    private Encryption encryption = Encryption.DEFAULT;
    private boolean nonInteractive;
    private boolean version;
    private boolean driverVersion;
    private int numSampleRows = 1000;
    private boolean wrap = true;
    private String inputFilename;
    private List<ParameterService.RawParameter> parameters;
    private boolean changePassword;
    private Path historyFile = Historian.defaultHistoryFile();
    private Handler logHandler;

    public void setUsername(String primary, String fallback) {
        this.username = primary == null ? fallback : primary;
    }

    public void setImpersonatedUser(String impersonatedUser) {
        this.impersonatedUser = Optional.ofNullable(impersonatedUser);
    }

    public void setPassword(String primary, String fallback) {
        this.password = primary == null ? fallback : primary;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getDatabase() {
        return this.databaseName;
    }

    public void setDatabase(String databaseName) {
        this.databaseName = databaseName;
    }

    public FailBehavior getFailBehavior() {
        return this.failBehavior;
    }

    void setFailBehavior(FailBehavior failBehavior) {
        this.failBehavior = failBehavior;
    }

    public Optional<String> getCypher() {
        return this.cypher;
    }

    public void setCypher(String cypher) {
        this.cypher = Optional.ofNullable(cypher);
    }

    public Format getFormat() {
        return this.format;
    }

    public void setFormat(Format format) {
        this.format = format;
    }

    public void setParameters(List<ParameterService.RawParameter> parameters) {
        this.parameters = parameters;
    }

    public Encryption getEncryption() {
        return this.encryption;
    }

    public void setEncryption(Encryption encryption) {
        this.encryption = encryption;
    }

    public boolean getNonInteractive() {
        return this.nonInteractive;
    }

    public void setNonInteractive(boolean nonInteractive) {
        this.nonInteractive = nonInteractive;
    }

    public String getInputFilename() {
        return this.inputFilename;
    }

    public void setInputFilename(String inputFilename) {
        this.inputFilename = inputFilename;
    }

    public boolean getVersion() {
        return this.version;
    }

    public void setVersion(boolean version) {
        this.version = version;
    }

    public boolean getDriverVersion() {
        return this.driverVersion;
    }

    public void setDriverVersion(boolean version) {
        this.driverVersion = version;
    }

    public boolean isStringShell() {
        return this.cypher.isPresent();
    }

    public boolean getWrap() {
        return this.wrap;
    }

    public void setWrap(boolean wrap) {
        this.wrap = wrap;
    }

    public int getNumSampleRows() {
        return this.numSampleRows;
    }

    public void setNumSampleRows(Integer numSampleRows) {
        if (numSampleRows != null && numSampleRows > 0) {
            this.numSampleRows = numSampleRows;
        }
    }

    public List<ParameterService.RawParameter> getParameters() {
        return this.parameters;
    }

    public void setChangePassword(boolean changePassword) {
        this.changePassword = changePassword;
    }

    public boolean getChangePassword() {
        return this.changePassword;
    }

    public ConnectionConfig connectionConfig() {
        return new ConnectionConfig(this.getUri(), this.getUsername(), this.getPassword(), this.getEncryption(), this.getDatabase(), this.impersonatedUser);
    }

    public Path getHistoryFile() {
        return this.historyFile;
    }

    public void setHistoryFile(Path historyFile) {
        this.historyFile = historyFile;
    }

    public URI getUri() {
        return this.uri;
    }

    public void setUri(URI uri) {
        this.uri = uri;
    }

    public Optional<Handler> logHandler() {
        return Optional.ofNullable(this.logHandler);
    }

    public void setLogHandler(Handler handler) {
        this.logHandler = handler;
    }
}

