/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shell;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Optional;
import org.neo4j.shell.cli.Encryption;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public record ConnectionConfig(URI uri, String username, String password, Encryption encryption, String database, Optional<String> impersonatedUser) {
    public ConnectionConfig withPassword(String password) {
        return new ConnectionConfig(this.uri, this.username, password, this.encryption, this.database, this.impersonatedUser);
    }

    public ConnectionConfig withUsernameAndPassword(String username, String password) {
        return new ConnectionConfig(this.uri, username, password, this.encryption, this.database, this.impersonatedUser);
    }

    public ConnectionConfig withUsernameAndPasswordAndDatabase(String username, String password, String database) {
        return new ConnectionConfig(this.uri, username, password, this.encryption, database, this.impersonatedUser);
    }

    public ConnectionConfig withScheme(String scheme) {
        try {
            URI newUri = new URI(scheme, this.uri.getUserInfo(), this.uri.getHost(), this.uri.getPort(), this.uri.getPath(), this.uri.getQuery(), this.uri.getFragment());
            return new ConnectionConfig(newUri, this.username, this.password, this.encryption, this.database, this.impersonatedUser);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Invalid scheme " + scheme, e);
        }
    }

    public ConnectionConfig withImpersonatedUser(String impersonatedUser) {
        return new ConnectionConfig(this.uri, this.username, this.password, this.encryption, this.database, Optional.ofNullable(impersonatedUser));
    }
}

