/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shell.printer;

import org.fusesource.jansi.Ansi;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class AnsiFormattedText {
    private final Ansi ansi = Ansi.ansi();
    private final StringBuilder plain = new StringBuilder();
    private boolean needsReset = false;

    public static AnsiFormattedText s() {
        return new AnsiFormattedText();
    }

    public static AnsiFormattedText from(String string) {
        return new AnsiFormattedText().append(string != null ? string : "");
    }

    private AnsiFormattedText reset() {
        if (this.needsReset) {
            this.ansi.reset();
            this.needsReset = false;
        }
        return this;
    }

    public String resetAndRender() {
        this.reset();
        return this.ansi.toString();
    }

    public String plainString() {
        return this.plain.toString();
    }

    public AnsiFormattedText append(CharSequence s) {
        this.ansi.a(s);
        this.plain.append(s);
        return this;
    }

    public AnsiFormattedText append(AnsiFormattedText s) {
        this.ansi.a(s.resetAndRender());
        this.plain.append((CharSequence)s.plain);
        this.needsReset = false;
        return this;
    }

    public AnsiFormattedText newLine() {
        return this.append(System.lineSeparator());
    }

    private AnsiFormattedText formatChange() {
        this.needsReset = true;
        return this;
    }

    public AnsiFormattedText bold() {
        this.ansi.bold();
        return this.formatChange();
    }

    public AnsiFormattedText bold(String bold) {
        return this.bold().append(bold).boldOff();
    }

    public AnsiFormattedText boldOff() {
        this.ansi.boldOff();
        return this.formatChange();
    }

    public AnsiFormattedText colorRed() {
        this.ansi.fgRed();
        return this.formatChange();
    }

    public AnsiFormattedText colorRed(CharSequence s) {
        return this.colorRed().append(s).colorDefault();
    }

    public AnsiFormattedText brightRed() {
        this.ansi.fgBrightRed();
        return this.formatChange();
    }

    public AnsiFormattedText brightRed(CharSequence s) {
        return this.brightRed().append(s).colorDefault();
    }

    public AnsiFormattedText colorOrange() {
        this.ansi.fgYellow();
        return this.formatChange();
    }

    public AnsiFormattedText orange(String s) {
        return this.colorOrange().append(s).colorDefault();
    }

    public AnsiFormattedText colorDefault() {
        this.ansi.fgDefault();
        return this.formatChange();
    }

    public int textLength() {
        return this.plain.length();
    }
}

