/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shell.completions;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.Parser;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.Vocabulary;
import org.antlr.v4.runtime.tree.ErrorNode;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.ParseTreeListener;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.neo4j.cypher.internal.ast.factory.neo4j.completion.CodeCompletionCore;
import org.neo4j.cypher.internal.parser.v5.Cypher5Lexer;
import org.neo4j.cypher.internal.parser.v5.Cypher5Parser;
import org.neo4j.cypher.internal.parser.v5.ast.factory.Cypher5AstLexer;
import org.neo4j.shell.completions.DbInfo;
import org.neo4j.shell.completions.Suggestion;
import org.neo4j.shell.completions.SuggestionType;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class CompletionEngine {
    Set<Integer> lexerKeywords;
    Set<Integer> rulesDefiningVariables;
    Set<Integer> rulesDefiningOrUsingVariables;
    Map<Integer, String> customTokenDisplayNames;
    Vocabulary vocabulary;
    DbInfo dbInfo;

    public CompletionEngine(DbInfo dbInfo) {
        this.dbInfo = dbInfo;
        this.customTokenDisplayNames = Map.of(17, "allShortestPaths", 253, "shortestPath");
        this.vocabulary = Cypher5Lexer.VOCABULARY;
        Set<Integer> ignoreFromLexer = Set.of(4, 5, 6, 7, 8, 9, 313, -1, 1, 309, 10, 3, 2);
        this.lexerKeywords = new HashSet<Integer>();
        for (int i = 0; i < Cypher5Lexer.VOCABULARY.getMaxTokenType(); ++i) {
            if (this.vocabulary.getLiteralName(i) != null || ignoreFromLexer.contains(i)) continue;
            this.lexerKeywords.add(i);
        }
        this.rulesDefiningVariables = Set.of(Integer.valueOf(11), Integer.valueOf(33), Integer.valueOf(45), Integer.valueOf(37), Integer.valueOf(39), Integer.valueOf(38), Integer.valueOf(115), Integer.valueOf(116), Integer.valueOf(113));
        this.rulesDefiningOrUsingVariables = new HashSet<Integer>(this.rulesDefiningVariables);
        this.rulesDefiningOrUsingVariables.addAll(List.of(Integer.valueOf(49), Integer.valueOf(59), Integer.valueOf(71)));
    }

    public List<Suggestion> completeQuery(String incompleteQuery) throws IOException {
        Token previousToken;
        Cypher5AstLexer lexer = Cypher5AstLexer.fromString((String)incompleteQuery, (boolean)true);
        CommonTokenStream tokenStream = new CommonTokenStream((TokenSource)lexer);
        Cypher5Parser parser = new Cypher5Parser((TokenStream)tokenStream);
        Vocabulary vocabulary = Cypher5Lexer.VOCABULARY;
        VariableCollector variableCollector = new VariableCollector((TokenStream)tokenStream);
        parser.addParseListener((ParseTreeListener)variableCollector);
        lexer.removeErrorListeners();
        parser.removeErrorListeners();
        Cypher5Parser.StatementsContext rootCtx = parser.statements();
        ParserRuleContext stopNode = this.findStopNode(rootCtx);
        List tokens = tokenStream.getTokens();
        List<String> collectedVariables = variableCollector.variables;
        int caretIndex = tokens.size() - 1;
        Token token = previousToken = tokens.size() > 1 ? (Token)tokens.get(caretIndex - 1) : null;
        if (previousToken != null && (previousToken.getType() == 309 || this.lexerKeywords.contains(previousToken.getType()))) {
            --caretIndex;
        }
        Set<Integer> preferredRules = Set.of(Integer.valueOf(136), Integer.valueOf(35), Integer.valueOf(84), Integer.valueOf(319), Integer.valueOf(132), Integer.valueOf(131), Integer.valueOf(138), Integer.valueOf(73), Integer.valueOf(315), Integer.valueOf(331));
        HashSet<Integer> ignoredTokens = new HashSet<Integer>();
        for (int i = -1; i <= vocabulary.getMaxTokenType(); ++i) {
            if (this.lexerKeywords.contains(i)) continue;
            ignoredTokens.add(i);
        }
        CodeCompletionCore completionEngine = new CodeCompletionCore((Parser)parser, preferredRules, ignoredTokens);
        CodeCompletionCore.CandidatesCollection candidates = completionEngine.collectCandidates(caretIndex, null);
        List<Suggestion> tokenCompletions = this.getTokenCompletions(candidates, ignoredTokens, (Cypher5Lexer)lexer);
        List<Suggestion> ruleCompletions = this.getRuleCompletions(candidates, collectedVariables, tokens, stopNode);
        ArrayList<Suggestion> result = new ArrayList<Suggestion>();
        result.addAll(tokenCompletions);
        result.addAll(ruleCompletions);
        return result;
    }

    private Stream<Suggestion> labelCompletions() {
        return this.dbInfo.labels.stream().map(Suggestion::labelOrRelType);
    }

    private Stream<Suggestion> relTypeCompletions() {
        return this.dbInfo.relationshipTypes.stream().map(Suggestion::labelOrRelType);
    }

    private Stream<Suggestion> propertyKeyCompletions() {
        return this.dbInfo.propertyKeys.stream().map(Suggestion::property);
    }

    private ParserRuleContext findStopNode(Cypher5Parser.StatementsContext root) {
        List children = root.children;
        Cypher5Parser.StatementsContext current = root;
        while (children != null && !children.isEmpty()) {
            int index = children.size() - 1;
            ParseTree child = (ParseTree)children.get(index);
            while (index > 0 && (child == root.EOF() || child.getText().isEmpty() || child.getText().startsWith("<missing"))) {
                child = (ParseTree)children.get(--index);
            }
            if (child instanceof ParserRuleContext) {
                current = (ParserRuleContext)child;
                children = current.children;
                continue;
            }
            children = null;
        }
        return current;
    }

    private List<Suggestion> getRuleCompletions(CodeCompletionCore.CandidatesCollection candidates, List<String> collectedVariables, List<Token> tokens, ParserRuleContext stopNode) {
        return candidates.rules.entrySet().stream().flatMap(entry -> {
            Integer ruleNumber = (Integer)entry.getKey();
            CodeCompletionCore.CandidateRule candidateRule = (CodeCompletionCore.CandidateRule)entry.getValue();
            int startTokenIndex = candidateRule.startTokenIndex();
            List ruleList = candidateRule.ruleList();
            if (ruleNumber == 136) {
                return this.functionNameCompletions(startTokenIndex, tokens);
            }
            if (ruleNumber == 35) {
                return this.procedureNameCompletions(startTokenIndex, tokens);
            }
            if (ruleNumber == 132) {
                return this.parameterCompletions(this.inferExpectedParameterTypeFromContext(candidateRule));
            }
            if (ruleNumber == 131) {
                String variableName;
                ParserRuleContext expr2;
                Integer parentRule = (Integer)ruleList.get(ruleList.size() - 1);
                Integer grandParentRule = (Integer)ruleList.get(ruleList.size() - 2);
                if (parentRule == 327 && grandParentRule == 107) {
                    return Stream.empty();
                }
                Integer greatGrandParentRule = (Integer)ruleList.get(ruleList.size() - 3);
                if (parentRule == 102 && grandParentRule == 101 && greatGrandParentRule == 100 && (expr2 = stopNode.getParent().getParent().getParent()) instanceof Cypher5Parser.Expression2Context && ((variableName = ((Cypher5Parser.Expression2Context)expr2).expression1().variable().getText()) == null || collectedVariables.contains(variableName))) {
                    return Stream.empty();
                }
                return this.propertyKeyCompletions();
            }
            if (ruleNumber == 138) {
                Integer parentRule;
                if (!ruleList.isEmpty() && !this.rulesDefiningVariables.contains(parentRule = (Integer)ruleList.get(ruleList.size() - 1))) {
                    return collectedVariables.stream().map(Suggestion::identifier);
                }
            } else if (ruleNumber == 84) {
                int topExprIndex = ruleList.indexOf(77);
                if (topExprIndex > 0) {
                    Integer topExprParent = (Integer)ruleList.get(topExprIndex - 1);
                    if (topExprParent == 59) {
                        return this.labelCompletions();
                    }
                    if (topExprParent == 71) {
                        return this.relTypeCompletions();
                    }
                    return Stream.concat(this.labelCompletions(), this.relTypeCompletions());
                }
            } else {
                if (ruleNumber == 319) {
                    return this.completeAliasName(tokens, candidateRule, startTokenIndex);
                }
                if (ruleNumber == 315) {
                    return this.completeSymbolicName(candidateRule, tokens, startTokenIndex);
                }
            }
            return Stream.empty();
        }).collect(Collectors.toList());
    }

    private ParameterType inferExpectedParameterTypeFromContext(CodeCompletionCore.CandidateRule candidateRule) {
        List ruleList = candidateRule.ruleList();
        Integer parentRule = (Integer)ruleList.get(ruleList.size() - 1);
        if (Set.of(324, 315, 314, 316, 318, 227, 219, 220, 223, 221, 213, 214, 202, 203, 215).contains(parentRule)) {
            return ParameterType.STRING;
        }
        if (Set.of(Integer.valueOf(70), Integer.valueOf(326)).contains(parentRule)) {
            return ParameterType.MAP;
        }
        return ParameterType.ANY;
    }

    private Optional<Token> findPreviousNonSpace(List<Token> tokens, int index) {
        int i = index;
        while (i > 0) {
            Token token;
            if ((token = tokens.get(--i)).getType() == 1) continue;
            return Optional.of(token);
        }
        return Optional.empty();
    }

    private Stream<Suggestion> completeSymbolicName(CodeCompletionCore.CandidateRule candidateRule, List<Token> tokens, int ruleStartTokenIndex) {
        Stream<Suggestion> parameterSuggestions = this.parameterCompletions(this.inferExpectedParameterTypeFromContext(candidateRule));
        List ruleList = candidateRule.ruleList();
        List<Integer> rulesCreatingNewUserOrRole = List.of(Integer.valueOf(219), Integer.valueOf(213));
        Optional<Token> previousToken = this.findPreviousNonSpace(tokens, ruleStartTokenIndex);
        boolean afterToToken = previousToken.stream().anyMatch(t -> t.getType() == 274);
        if (rulesCreatingNewUserOrRole.stream().anyMatch(ruleList::contains) || candidateRule.ruleList().contains(221) && afterToToken) {
            return parameterSuggestions;
        }
        List<Integer> rulesThatAcceptExistingUsers = List.of(Integer.valueOf(220), Integer.valueOf(221), Integer.valueOf(223), Integer.valueOf(202));
        if (rulesThatAcceptExistingUsers.stream().anyMatch(ruleList::contains)) {
            return Stream.concat(parameterSuggestions, this.dbInfo.userNames.stream().map(Suggestion::value));
        }
        List<Integer> rulesThatAcceptExistingRoles = List.of(Integer.valueOf(203), Integer.valueOf(214), Integer.valueOf(215));
        if (rulesThatAcceptExistingRoles.stream().anyMatch(ruleList::contains)) {
            return Stream.concat(parameterSuggestions, this.dbInfo.roleNames.stream().map(Suggestion::value));
        }
        return Stream.empty();
    }

    private Stream<Suggestion> completeAliasName(List<Token> tokens, CodeCompletionCore.CandidateRule candidateRule, int ruleStartTokenIndex) {
        List ruleList = candidateRule.ruleList();
        if (ruleStartTokenIndex + 1 < tokens.size() && tokens.get(ruleStartTokenIndex + 1).getType() == 1) {
            return Stream.empty();
        }
        Stream<Suggestion> parameterSuggestions = this.parameterCompletions(ParameterType.STRING);
        List<Integer> rulesCreatingNewDb = List.of(Integer.valueOf(287), Integer.valueOf(286));
        if (rulesCreatingNewDb.stream().anyMatch(ruleList::contains)) {
            return parameterSuggestions;
        }
        if (ruleList.contains(305) && ruleList.contains(303)) {
            return parameterSuggestions;
        }
        List<Integer> rulesThatOnlyAcceptAlias = List.of(Integer.valueOf(306), Integer.valueOf(307), Integer.valueOf(313));
        if (rulesThatOnlyAcceptAlias.stream().anyMatch(ruleList::contains)) {
            return Stream.concat(parameterSuggestions, this.dbInfo.aliasNames.stream().map(Suggestion::value));
        }
        return Stream.concat(Stream.concat(parameterSuggestions, this.dbInfo.databaseNames.stream().map(Suggestion::value)), this.dbInfo.aliasNames.stream().map(Suggestion::value));
    }

    private String calculateNamespacePrefix(int startTokenIndex, List<Token> tokens) {
        boolean lastNonSpaceIsDot;
        List<Token> ruleTokens = tokens.subList(startTokenIndex, tokens.size() - 1);
        Token lastNonEOFToken = ruleTokens.size() >= 2 ? ruleTokens.get(ruleTokens.size() - 2) : null;
        ArrayList<Token> nonSpaceTokens = new ArrayList<Token>(ruleTokens.stream().filter(token -> token.getType() != 1 && token.getType() != -1).toList());
        boolean bl = lastNonSpaceIsDot = !nonSpaceTokens.isEmpty() && nonSpaceTokens.get(nonSpaceTokens.size() - 1).getType() == 83;
        if (lastNonEOFToken != null && lastNonEOFToken.getType() == 1 && !lastNonSpaceIsDot) {
            return null;
        }
        if (!lastNonSpaceIsDot && !nonSpaceTokens.isEmpty()) {
            nonSpaceTokens.remove(nonSpaceTokens.size() - 1);
        }
        String namespacePrefix = nonSpaceTokens.stream().map(Token::getText).collect(Collectors.joining(""));
        return namespacePrefix;
    }

    private Stream<Suggestion> functionNameCompletions(int ruleStartTokenIndex, List<Token> tokens) {
        return this.namespacedCompletion(ruleStartTokenIndex, tokens, this.dbInfo.functions, SuggestionType.FUNCTION);
    }

    private Stream<Suggestion> procedureNameCompletions(int ruleStartTokenIndex, List<Token> tokens) {
        return this.namespacedCompletion(ruleStartTokenIndex, tokens, this.dbInfo.procedures, SuggestionType.PROCEDURE);
    }

    private Stream<Suggestion> getNamespaceSuggestions(Stream<String> namespaces, SuggestionType suggestionType) {
        return namespaces.map(completion -> {
            if (suggestionType == SuggestionType.FUNCTION) {
                return Suggestion.functionNamespace(completion);
            }
            return Suggestion.procedureNamespace(completion);
        }).collect(Collectors.toSet()).stream();
    }

    private Stream<Suggestion> getFullNameSuggestions(Stream<String> fullNames, SuggestionType suggestionType) {
        return fullNames.map(completion -> {
            if (suggestionType == SuggestionType.FUNCTION) {
                return Suggestion.function(completion);
            }
            return Suggestion.procedure(completion);
        });
    }

    private Stream<Suggestion> namespacedCompletion(int ruleStartTokenIndex, List<Token> tokens, List<String> signatures, SuggestionType suggestionType) {
        HashSet<String> fullNames = new HashSet<String>(signatures);
        String namespacePrefix = this.calculateNamespacePrefix(ruleStartTokenIndex, tokens);
        if (namespacePrefix == null) {
            return Stream.empty();
        }
        if (namespacePrefix.isEmpty()) {
            Stream<String> topLevelPrefixes = fullNames.stream().filter(fn -> fn.contains(".")).map(fnName -> fnName.split("\\.")[0]);
            Stream<Suggestion> namespaceCompletions = this.getNamespaceSuggestions(topLevelPrefixes, suggestionType);
            Stream<Suggestion> fullNameCompletions = this.getFullNameSuggestions(fullNames.stream(), suggestionType);
            return Stream.concat(namespaceCompletions, fullNameCompletions);
        }
        HashSet<String> fullNameOptions = new HashSet<String>();
        HashSet<String> namespaceOptions = new HashSet<String>();
        for (String name : fullNames) {
            boolean isFunctionName;
            if (!name.startsWith(namespacePrefix)) continue;
            String[] splitByDot = name.substring(namespacePrefix.length()).split("\\.");
            String option = splitByDot[0];
            boolean bl = isFunctionName = splitByDot.length == 1;
            if (option.isEmpty()) continue;
            if (isFunctionName) {
                fullNameOptions.add(option);
                continue;
            }
            namespaceOptions.add(option);
        }
        Stream<Suggestion> namespaceCompletions = this.getNamespaceSuggestions(namespaceOptions.stream(), suggestionType);
        Stream<Suggestion> fullNameCompletions = this.getFullNameSuggestions(fullNameOptions.stream(), suggestionType);
        return Stream.concat(namespaceCompletions, fullNameCompletions);
    }

    private Stream<Suggestion> parameterCompletions(ParameterType expectedType) {
        Stream<Suggestion> result = this.dbInfo.parameters().entrySet().stream().filter(entry -> expectedType == ParameterType.ANY || entry.getValue() == expectedType).map(parameter -> Suggestion.parameter("$" + (String)parameter.getKey()));
        return result;
    }

    private String getTokenName(int token) {
        if (this.customTokenDisplayNames.containsKey(token)) {
            return this.customTokenDisplayNames.get(token);
        }
        return this.vocabulary.getDisplayName(token);
    }

    private List<Suggestion> getTokenCompletions(CodeCompletionCore.CandidatesCollection candidates, Set<Integer> ignoredTokens, Cypher5Lexer cypherLexer) {
        Set tokenEntries = candidates.tokens.entrySet();
        Stream<Suggestion> completions = tokenEntries.stream().flatMap(value -> {
            Integer tokenNumber = (Integer)value.getKey();
            List followUpList = (List)value.getValue();
            if (!ignoredTokens.contains(tokenNumber)) {
                String firstToken = this.getTokenName(tokenNumber);
                int lastIndexToSlice = followUpList.size();
                for (int i = 0; i < followUpList.size() && lastIndexToSlice == followUpList.size(); ++i) {
                    if (!ignoredTokens.contains(followUpList.get(i))) continue;
                    lastIndexToSlice = i;
                }
                List followUpTokens = followUpList.subList(0, lastIndexToSlice);
                String followUpString = followUpTokens.stream().map(this::getTokenName).collect(Collectors.joining("  "));
                if (!followUpString.isEmpty()) {
                    return Stream.of(firstToken + " " + followUpString);
                }
                return Stream.of(firstToken);
            }
            return Stream.of(new String[0]);
        });
        List<Suggestion> result = completions.map(Suggestion::keyword).collect(Collectors.toList());
        return result;
    }

    public boolean completionsEnabled() {
        return this.dbInfo.completionsEnabled();
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    class VariableCollector
    implements ParseTreeListener {
        private final List<String> variables = new ArrayList<String>();
        TokenStream tokens;

        public VariableCollector(TokenStream tokens) {
            this.tokens = tokens;
        }

        public void visitTerminal(TerminalNode node) {
        }

        public void visitErrorNode(ErrorNode node) {
        }

        public void enterEveryRule(ParserRuleContext ctx) {
        }

        public void exitEveryRule(ParserRuleContext ctx) {
            if (ctx.getRuleIndex() == 138) {
                boolean definesVariable;
                Cypher5Parser.VariableContext c = (Cypher5Parser.VariableContext)ctx;
                String variable = c.symbolicVariableNameString().getText();
                int tokenIndex = c.stop.getTokenIndex();
                boolean nextTokenIsEOF = tokenIndex != -1 && this.tokens.get(tokenIndex + 1).getType() == -1;
                boolean bl = definesVariable = c.getParent() != null && CompletionEngine.this.rulesDefiningOrUsingVariables.contains(c.getParent().getRuleIndex());
                if (variable != null && !nextTokenIsEOF && definesVariable) {
                    this.variables.add(variable);
                }
            }
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static enum ParameterType {
        STRING,
        MAP,
        ANY;

    }
}

