/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shell.commands;

import java.util.List;
import org.neo4j.shell.CypherShell;
import org.neo4j.shell.commands.Command;
import org.neo4j.shell.exception.CommandException;
import org.neo4j.shell.exception.ExitException;
import org.neo4j.shell.printer.Printer;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public record Impersonate(CypherShell shell, Printer printer) implements Command
{
    @Override
    public void execute(List<String> args) throws ExitException, CommandException {
        this.requireArgumentCount(args, 0, 1);
        this.shell.impersonate(args.isEmpty() ? null : args.get(0));
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static class Factory
    implements Command.Factory {
        @Override
        public Command.Metadata metadata() {
            String help = "Enable user impersonation.";
            String usage = " <user to impersonate>, or without arguments to reset impersonation";
            return new Command.Metadata(":impersonate", "Impersonate user", usage, help, List.of());
        }

        @Override
        public Command executor(Command.Factory.Arguments args) {
            return new Impersonate(args.cypherShell(), args.printer());
        }
    }
}

