/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shell.printer;

import java.io.PrintStream;
import org.fusesource.jansi.Ansi;
import org.fusesource.jansi.AnsiConsole;
import org.fusesource.jansi.internal.CLibrary;
import org.neo4j.driver.exceptions.ClientException;
import org.neo4j.driver.exceptions.DiscoveryException;
import org.neo4j.driver.exceptions.ServiceUnavailableException;
import org.neo4j.shell.cli.Format;
import org.neo4j.shell.exception.AnsiFormattedException;
import org.neo4j.shell.log.Logger;
import org.neo4j.shell.printer.AnsiFormattedText;
import org.neo4j.shell.printer.Printer;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class AnsiPrinter
implements Printer {
    private static final Logger log = Logger.create();
    private final PrintStream out;
    private final PrintStream err;
    private Format format;

    public AnsiPrinter() {
        this(Format.VERBOSE, System.out, System.err);
    }

    public AnsiPrinter(Format format, PrintStream out, PrintStream err) {
        this.format = format;
        this.out = out;
        this.err = err;
        try {
            if (AnsiPrinter.isOutputInteractive()) {
                Ansi.setEnabled((boolean)true);
                AnsiConsole.systemInstall();
            } else {
                Ansi.setEnabled((boolean)false);
            }
        }
        catch (Throwable t) {
            log.warn("Not running on a distro with standard c library, disabling Ansi", t);
            Ansi.setEnabled((boolean)false);
        }
    }

    private static Throwable getRootCause(Throwable th) {
        Throwable cause = th;
        while (cause.getCause() != null) {
            cause = cause.getCause();
        }
        return cause;
    }

    private static boolean isOutputInteractive() {
        return 1 == CLibrary.isatty((int)CLibrary.STDOUT_FILENO) && 1 == CLibrary.isatty((int)CLibrary.STDERR_FILENO);
    }

    @Override
    public Format getFormat() {
        return this.format;
    }

    @Override
    public void setFormat(Format format) {
        this.format = format;
    }

    @Override
    public void printError(Throwable throwable) {
        this.printError(this.getFormattedMessage(throwable));
    }

    @Override
    public void printError(String s) {
        this.err.println(Ansi.ansi().render(s).toString());
    }

    @Override
    public void printOut(String msg) {
        this.out.println(Ansi.ansi().render(msg).toString());
    }

    public String getFormattedMessage(Throwable e) {
        AnsiFormattedText msg = AnsiFormattedText.s().colorRed();
        if (e instanceof AnsiFormattedException) {
            msg = msg.append(((AnsiFormattedException)e).getFormattedMessage());
        } else if (e instanceof ClientException && e.getMessage() != null && e.getMessage().contains("Missing username")) {
            msg = msg.append(e.getMessage()).append("\nPlease specify --username, and optionally --password, as argument(s)").append("\nor as environment variable(s), NEO4J_USERNAME, and NEO4J_PASSWORD respectively.").append("\nSee --help for more info.");
        } else {
            Throwable cause = e;
            if (e instanceof ServiceUnavailableException) {
                Throwable[] suppressed;
                for (Throwable s : suppressed = e.getSuppressed()) {
                    if (!(s instanceof DiscoveryException)) continue;
                    cause = AnsiPrinter.getRootCause(s);
                    break;
                }
            }
            msg = cause.getMessage() != null ? msg.append(cause.getMessage()) : msg.append(cause.getClass().getSimpleName());
        }
        return msg.formattedString();
    }
}

