/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shell.prettyprint;

import java.util.Set;
import org.neo4j.driver.summary.ResultSummary;
import org.neo4j.shell.cli.Format;
import org.neo4j.shell.prettyprint.LinePrinter;
import org.neo4j.shell.prettyprint.OutputFormatter;
import org.neo4j.shell.prettyprint.PrettyConfig;
import org.neo4j.shell.prettyprint.SimpleOutputFormatter;
import org.neo4j.shell.prettyprint.StatisticsCollector;
import org.neo4j.shell.prettyprint.TableOutputFormatter;
import org.neo4j.shell.state.BoltResult;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class PrettyPrinter {
    private final StatisticsCollector statisticsCollector;
    private final OutputFormatter outputFormatter;
    private final boolean displayNotifications;

    public PrettyPrinter(PrettyConfig prettyConfig) {
        this.statisticsCollector = new StatisticsCollector(prettyConfig.format());
        this.outputFormatter = PrettyPrinter.selectFormatter(prettyConfig);
        this.displayNotifications = prettyConfig.displayNotifications();
    }

    public void format(BoltResult result, LinePrinter linePrinter) {
        Set<OutputFormatter.Capabilities> capabilities = this.outputFormatter.capabilities();
        int numberOfRows = 0;
        if (capabilities.contains((Object)OutputFormatter.Capabilities.RESULT)) {
            numberOfRows = this.outputFormatter.formatAndCount(result, linePrinter);
        }
        if (capabilities.contains((Object)OutputFormatter.Capabilities.INFO)) {
            PrettyPrinter.printIfNotEmpty(this.outputFormatter.formatInfo(result.getSummary()), linePrinter);
        }
        if (capabilities.contains((Object)OutputFormatter.Capabilities.PLAN)) {
            PrettyPrinter.printIfNotEmpty(this.outputFormatter.formatPlan(result.getSummary()), linePrinter);
        }
        if (capabilities.contains((Object)OutputFormatter.Capabilities.FOOTER)) {
            PrettyPrinter.printIfNotEmpty(this.outputFormatter.formatFooter(result, numberOfRows), linePrinter);
        }
        ResultSummary summary = result.getSummary();
        if (capabilities.contains((Object)OutputFormatter.Capabilities.STATISTICS)) {
            PrettyPrinter.printIfNotEmpty(this.statisticsCollector.collect(summary), linePrinter);
        }
        if (this.displayNotifications && capabilities.contains((Object)OutputFormatter.Capabilities.NOTIFICATIONS)) {
            PrettyPrinter.printIfNotEmpty(this.outputFormatter.formatNotifications(summary.notifications()), linePrinter);
        }
    }

    String format(BoltResult result) {
        StringBuilder sb = new StringBuilder();
        this.format(result, line -> {
            if (line != null && !line.trim().isEmpty()) {
                sb.append(line).append(OutputFormatter.NEWLINE);
            }
        });
        return sb.toString();
    }

    private static void printIfNotEmpty(String s, LinePrinter linePrinter) {
        if (!s.isEmpty()) {
            linePrinter.printOut(s);
        }
    }

    private static OutputFormatter selectFormatter(PrettyConfig prettyConfig) {
        if (prettyConfig.format() == Format.VERBOSE) {
            return new TableOutputFormatter(prettyConfig.wrap(), prettyConfig.numSampleRows());
        }
        return new SimpleOutputFormatter();
    }
}

