/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shell.parameter;

import java.util.List;
import java.util.Map;
import org.neo4j.driver.Value;
import org.neo4j.shell.TransactionHandler;
import org.neo4j.shell.exception.CommandException;
import org.neo4j.shell.parameter.ShellParameterService;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public interface ParameterService {
    public Map<String, Value> parameters();

    public List<Parameter> evaluate(RawParameters var1) throws CommandException;

    public void setParameters(List<Parameter> var1);

    public RawParameters parse(String var1) throws ParameterParsingException;

    public String pretty();

    public void clear();

    public static ParameterService create(TransactionHandler db) {
        return new ShellParameterService(db);
    }

    public static ParameterParser createParser() {
        return new ShellParameterService.ShellParameterParser();
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static class ParameterEvaluationException
    extends RuntimeException {
        ParameterEvaluationException(String message, Throwable cause) {
            super(message, cause);
        }

        ParameterEvaluationException(String message) {
            super(message);
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static class ParameterParsingException
    extends RuntimeException {
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public record Parameter(String name, Value value) {
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public record RawParameters(String expression) {
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static interface ParameterEvaluator {
        public List<Parameter> evaluate(RawParameters var1) throws CommandException;
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static interface ParameterParser {
        public RawParameters parse(String var1) throws ParameterParsingException;
    }
}

