/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shell.printer;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.fusesource.jansi.Ansi;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class AnsiFormattedText {
    private static final String RED = "RED";
    private static final String YELLOW = "YELLOW";
    private static final String BOLD = "BOLD";
    private static final String DEFAULT_COLOR = "DEFAULT";
    private final Map<String, Boolean> attributes = new HashMap<String, Boolean>();
    private final LinkedList<AnsiFormattedString> pieces = new LinkedList();
    private String color;

    private static <K, V> Map<K, V> mergeMaps(Map<K, V> primary, Map<K, V> secondary) {
        HashMap<K, V> result = new HashMap<K, V>(primary);
        secondary.forEach(result::putIfAbsent);
        return result;
    }

    public static AnsiFormattedText s() {
        return new AnsiFormattedText();
    }

    public static AnsiFormattedText from(String string) {
        AnsiFormattedText st = new AnsiFormattedText();
        if (string != null) {
            st.append(string);
        }
        return st;
    }

    public String formattedString() {
        StringBuilder sb = new StringBuilder();
        for (AnsiFormattedString s : this.pieces) {
            ArrayList<String> codes = new ArrayList<String>();
            if (s.color != null && !DEFAULT_COLOR.equals(s.color)) {
                codes.add(s.color);
            }
            if (s.attributes.getOrDefault(BOLD, false).booleanValue()) {
                codes.add(BOLD);
            }
            if (!codes.isEmpty()) {
                sb.append("@|").append(String.join((CharSequence)",", codes)).append(" ");
            }
            sb.append(s.string);
            if (codes.isEmpty()) continue;
            sb.append("|@");
        }
        return sb.toString();
    }

    public String renderedString() {
        return Ansi.ansi().render(this.formattedString()).toString();
    }

    public String plainString() {
        StringBuilder sb = new StringBuilder();
        this.pieces.forEach(sb::append);
        return sb.toString();
    }

    public AnsiFormattedText append(AnsiFormattedText existing) {
        existing.pieces.forEach(s -> this.pieces.add(new AnsiFormattedString(this.color != null ? this.color : s.color, AnsiFormattedText.mergeMaps(this.attributes, s.attributes), s.string)));
        return this;
    }

    public AnsiFormattedText append(String s) {
        this.pieces.add(new AnsiFormattedString(this.color, this.attributes, s));
        return this;
    }

    public AnsiFormattedText appendNewLine() {
        this.pieces.add(new AnsiFormattedString(this.color, this.attributes, System.lineSeparator()));
        return this;
    }

    public AnsiFormattedText bold() {
        this.attributes.put(BOLD, true);
        return this;
    }

    public AnsiFormattedText bold(String bold) {
        return this.bold().append(bold).boldOff();
    }

    public AnsiFormattedText boldOff() {
        this.attributes.put(BOLD, false);
        return this;
    }

    public AnsiFormattedText colorRed() {
        this.color = RED;
        return this;
    }

    public AnsiFormattedText colorOrange() {
        this.color = YELLOW;
        return this;
    }

    public AnsiFormattedText orange(String s) {
        this.pieces.add(new AnsiFormattedString(YELLOW, this.attributes, s));
        return this;
    }

    public AnsiFormattedText colorDefault() {
        this.color = DEFAULT_COLOR;
        return this;
    }

    public int textLength() {
        return this.pieces.stream().mapToInt(p -> p.string.length()).sum();
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    private static class AnsiFormattedString {
        final String color;
        final Map<String, Boolean> attributes = new HashMap<String, Boolean>();
        final String string;

        AnsiFormattedString(String color, Map<String, Boolean> attributes, String s) {
            this.color = color;
            this.attributes.putAll(attributes);
            this.string = s;
        }

        public String toString() {
            return this.string;
        }
    }
}

