/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shell.build;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

public class Build {
    private static Properties props;

    private static Properties getProperties() {
        if (props == null) {
            props = new Properties();
            try (InputStream stream = Build.class.getClassLoader().getResourceAsStream("build.properties");){
                if (stream == null) {
                    throw new IllegalStateException("Cannot read build.properties");
                }
                props.load(stream);
            }
            catch (IOException e) {
                System.err.println("Could not read build properties: " + e.getMessage());
            }
        }
        return props;
    }

    public static String version() {
        return Build.getProperties().getProperty("version", "dev");
    }

    public static String driverVersion() {
        return Build.getProperties().getProperty("driverVersion", "dev");
    }
}

