/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shell.commands;

import java.util.Arrays;
import java.util.List;
import org.neo4j.shell.commands.Command;
import org.neo4j.shell.commands.CommandHelper;
import org.neo4j.shell.exception.CommandException;
import org.neo4j.shell.exception.ExitException;
import org.neo4j.shell.log.AnsiFormattedText;
import org.neo4j.shell.log.Logger;

public class Exit
implements Command {
    public static final String COMMAND_NAME = ":exit";
    private final Logger logger;

    public Exit(Logger logger) {
        this.logger = logger;
    }

    @Override
    public String getName() {
        return COMMAND_NAME;
    }

    @Override
    public String getDescription() {
        return "Exit the logger";
    }

    @Override
    public String getUsage() {
        return "";
    }

    @Override
    public String getHelp() {
        return AnsiFormattedText.from("Exit the logger. Corresponds to entering ").bold("CTRL-D").append(".").formattedString();
    }

    @Override
    public List<String> getAliases() {
        return Arrays.asList(":quit");
    }

    @Override
    public void execute(String argString) throws ExitException, CommandException {
        CommandHelper.simpleArgParse(argString, 0, COMMAND_NAME, this.getUsage());
        throw new ExitException(0);
    }
}

