/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shell.commands;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import org.neo4j.shell.CypherShell;
import org.neo4j.shell.commands.Command;
import org.neo4j.shell.commands.CommandHelper;
import org.neo4j.shell.exception.CommandException;
import org.neo4j.shell.exception.ExitException;
import org.neo4j.shell.parser.StatementParser;

public class Source
implements Command {
    private static final String COMMAND_NAME = ":source";
    private final CypherShell cypherShell;
    private final StatementParser statementParser;

    public Source(CypherShell cypherShell, StatementParser statementParser) {
        this.cypherShell = cypherShell;
        this.statementParser = statementParser;
    }

    @Override
    @Nonnull
    public String getName() {
        return COMMAND_NAME;
    }

    @Override
    @Nonnull
    public String getDescription() {
        return "Interactively executes cypher statements from a file";
    }

    @Override
    @Nonnull
    public String getUsage() {
        return "[filename]";
    }

    @Override
    @Nonnull
    public String getHelp() {
        return "Executes Cypher statements from a file";
    }

    @Override
    @Nonnull
    public List<String> getAliases() {
        return Collections.emptyList();
    }

    @Override
    public void execute(@Nonnull String argString) throws ExitException, CommandException {
        String filename = CommandHelper.simpleArgParse(argString, 1, 1, COMMAND_NAME, this.getUsage())[0];
        try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(new FileInputStream(new File(filename))));){
            bufferedReader.lines().forEach(line -> this.statementParser.parseMoreText(line + "\n"));
            List<String> statements = this.statementParser.consumeStatements();
            for (String statement : statements) {
                this.cypherShell.execute(statement);
            }
        }
        catch (IOException e) {
            throw new CommandException(String.format("Cannot find file: '%s'", filename), e);
        }
    }
}

