/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shell.commands;

import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import org.neo4j.cypher.internal.evaluator.EvaluationException;
import org.neo4j.shell.ParameterMap;
import org.neo4j.shell.commands.Command;
import org.neo4j.shell.exception.CommandException;
import org.neo4j.shell.log.AnsiFormattedText;
import org.neo4j.shell.util.ParameterSetter;

public class Param
extends ParameterSetter<CommandException>
implements Command {
    private static final String COMMAND_NAME = ":param";

    public Param(@Nonnull ParameterMap parameterMap) {
        super(parameterMap);
    }

    @Override
    @Nonnull
    public String getName() {
        return COMMAND_NAME;
    }

    @Override
    @Nonnull
    public String getDescription() {
        return "Set the value of a query parameter";
    }

    @Override
    @Nonnull
    public String getUsage() {
        return "name => value";
    }

    @Override
    @Nonnull
    public String getHelp() {
        return "Set the specified query parameter to the value given";
    }

    @Override
    @Nonnull
    public List<String> getAliases() {
        return Collections.emptyList();
    }

    @Override
    protected void onWrongUsage() throws CommandException {
        throw new CommandException(AnsiFormattedText.from("Incorrect usage.\nusage: ").bold().append(COMMAND_NAME).boldOff().append(" ").append(this.getUsage()));
    }

    @Override
    protected void onWrongNumberOfArguments() throws CommandException {
        throw new CommandException(AnsiFormattedText.from("Incorrect number of arguments.\nusage: ").bold().append(COMMAND_NAME).boldOff().append(" ").append(this.getUsage()));
    }

    @Override
    protected void onEvaluationException(EvaluationException e) throws CommandException {
        throw new CommandException(e.getMessage(), (Throwable)e);
    }
}

