/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shell.cli;

import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.neo4j.shell.ParameterMap;
import org.neo4j.shell.ShellParameterMap;
import org.neo4j.shell.cli.Encryption;
import org.neo4j.shell.cli.FailBehavior;
import org.neo4j.shell.cli.Format;

public class CliArgs {
    static final String DEFAULT_SCHEME = "bolt";
    static final int DEFAULT_NUM_SAMPLE_ROWS = 1000;
    private static final String DEFAULT_HOST = "localhost";
    private static final int DEFAULT_PORT = 7687;
    private String scheme = "bolt";
    private String host = "localhost";
    private int port = 7687;
    private String username = "";
    private String password = "";
    private String databaseName = "";
    private FailBehavior failBehavior = FailBehavior.FAIL_FAST;
    private Format format = Format.AUTO;
    private Optional<String> cypher = Optional.empty();
    private Encryption encryption = Encryption.DEFAULT;
    private boolean debugMode;
    private boolean nonInteractive;
    private boolean version;
    private boolean driverVersion;
    private int numSampleRows = 1000;
    private boolean wrap = true;
    private String inputFilename;
    private ParameterMap parameters = new ShellParameterMap();

    public void setScheme(@Nullable String primary, @Nonnull String fallback) {
        this.scheme = primary == null ? fallback : primary;
    }

    void setHost(@Nullable String primary, @Nonnull String fallback) {
        this.host = primary == null ? fallback : primary;
    }

    public void setUsername(@Nullable String primary, @Nonnull String fallback) {
        this.username = primary == null ? fallback : primary;
    }

    public void setPassword(@Nullable String primary, @Nonnull String fallback) {
        this.password = primary == null ? fallback : primary;
    }

    @Nonnull
    public String getScheme() {
        return this.scheme;
    }

    @Nonnull
    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    @Nonnull
    public String getUsername() {
        return this.username;
    }

    @Nonnull
    public String getPassword() {
        return this.password;
    }

    @Nonnull
    public String getDatabase() {
        return this.databaseName;
    }

    public void setDatabase(@Nullable String databaseName) {
        this.databaseName = databaseName;
    }

    @Nonnull
    public FailBehavior getFailBehavior() {
        return this.failBehavior;
    }

    void setFailBehavior(@Nonnull FailBehavior failBehavior) {
        this.failBehavior = failBehavior;
    }

    @Nonnull
    public Optional<String> getCypher() {
        return this.cypher;
    }

    public void setCypher(@Nullable String cypher) {
        this.cypher = Optional.ofNullable(cypher);
    }

    @Nonnull
    public Format getFormat() {
        return this.format;
    }

    public void setFormat(@Nonnull Format format) {
        this.format = format;
    }

    public Encryption getEncryption() {
        return this.encryption;
    }

    public void setEncryption(Encryption encryption) {
        this.encryption = encryption;
    }

    public boolean getDebugMode() {
        return this.debugMode;
    }

    void setDebugMode(boolean enabled) {
        this.debugMode = enabled;
    }

    public boolean getNonInteractive() {
        return this.nonInteractive;
    }

    public void setNonInteractive(boolean nonInteractive) {
        this.nonInteractive = nonInteractive;
    }

    public String getInputFilename() {
        return this.inputFilename;
    }

    public void setInputFilename(String inputFilename) {
        this.inputFilename = inputFilename;
    }

    public boolean getVersion() {
        return this.version;
    }

    public void setVersion(boolean version) {
        this.version = version;
    }

    public boolean getDriverVersion() {
        return this.driverVersion;
    }

    public void setDriverVersion(boolean version) {
        this.driverVersion = version;
    }

    public boolean isStringShell() {
        return this.cypher.isPresent();
    }

    public boolean getWrap() {
        return this.wrap;
    }

    public void setWrap(boolean wrap) {
        this.wrap = wrap;
    }

    public int getNumSampleRows() {
        return this.numSampleRows;
    }

    public void setNumSampleRows(Integer numSampleRows) {
        if (numSampleRows != null && numSampleRows > 0) {
            this.numSampleRows = numSampleRows;
        }
    }

    public ParameterMap getParameters() {
        return this.parameters;
    }
}

