/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shell.prettyprint;

import java.util.Arrays;
import java.util.BitSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.neo4j.driver.Value;
import org.neo4j.driver.summary.Plan;
import org.neo4j.shell.prettyprint.AbstractTablePlanFormatter;
import org.neo4j.shell.prettyprint.OutputFormatter;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class TableScopePlanFormatter
extends AbstractTablePlanFormatter {
    public static final String OPERATOR = "Cypher";
    public static final int MAX_OPERATOR_COLUMN_WIDTH = 50;
    private static final String INCOMING_CONSTANTS = "Incoming consts";
    private static final String INCOMING_VARIABLES = "Incoming vars";
    private static final String INCOMING_TOPOLOGY_CONSTANTS = "Incoming topology vars";
    private static final String INCOMING_PREDICATE_VARIABLES = "Incoming predicate vars";
    private static final String INCOMING_PATH_VARIABLES = "Incoming path vars";
    private static final String REFERENCED = "Referenced";
    private static final String DECLARED_CONSTANTS = "Declared consts";
    private static final String DECLARED_VARIABLES = "Declared vars";
    private static final String RESULT_COLUMNS = "Result columns";
    private static final String OUTGOING_CONSTANTS = "Outgoing consts";
    private static final String OUTGOING_VARIABLES = "Outgoing vars";
    private static final Pattern NEWLINE_WHITESPACE_PATTERN = Pattern.compile("\\s*\\R\\s*");
    private static final List<String> HEADERS = Arrays.asList("Cypher", "Incoming consts", "Incoming vars", "Incoming topology vars", "Incoming predicate vars", "Incoming path vars", "Referenced", "Declared consts", "Declared vars", "Result columns", "Outgoing consts", "Outgoing vars");

    @Override
    protected String operatorHeader() {
        return OPERATOR;
    }

    @Override
    protected List<String> headers() {
        return HEADERS;
    }

    @Override
    protected Stream<List<AbstractTablePlanFormatter.TableRow>> children(Plan plan, AbstractTablePlanFormatter.Level level, Map<String, Integer> columns) {
        List children = plan.children();
        switch (children.size()) {
            case 0: {
                return Stream.empty();
            }
            case 1: {
                return Stream.of(this.accumulate((Plan)children.get(0), level.onlyChild(), columns));
            }
            case 2: {
                AbstractTablePlanFormatter.Level firstChildLevel = level.firstChild();
                return Stream.of(this.accumulate((Plan)children.get(0), firstChildLevel, columns), this.accumulate((Plan)children.get(1), firstChildLevel.lastSibling(), columns));
            }
        }
        AbstractTablePlanFormatter.Level firstChildLevel = level.firstChild();
        int lastChildIndex = children.size() - 1;
        return Stream.concat(Stream.concat(Stream.of(this.accumulate((Plan)children.get(0), firstChildLevel, columns)), children.subList(1, lastChildIndex).stream().map(child -> this.accumulate((Plan)child, firstChildLevel.sibling(), columns))), Stream.of(this.accumulate((Plan)children.get(lastChildIndex), firstChildLevel.lastSibling(), columns)));
    }

    @Override
    protected String operatorType(Plan plan, AbstractTablePlanFormatter.Level level) {
        String operatorString = NEWLINE_WHITESPACE_PATTERN.matcher(plan.operatorType()).replaceAll(" ");
        int availableWith = 50 - level.line().length();
        return operatorString.length() > availableWith ? operatorString.substring(0, availableWith - 3) + "..." : operatorString;
    }

    @Override
    protected Map<String, AbstractTablePlanFormatter.Cell> details(Plan plan, Map<String, Integer> columns) {
        Map args = plan.arguments();
        Stream<Optional> formattedPlan = args.entrySet().stream().map(e -> {
            Value value = (Value)e.getValue();
            switch ((String)e.getKey()) {
                case "incoming constants": {
                    return TableScopePlanFormatter.mapping(INCOMING_CONSTANTS, new AbstractTablePlanFormatter.LeftJustifiedCell(value.asString()), columns);
                }
                case "incoming variables": {
                    return TableScopePlanFormatter.mapping(INCOMING_VARIABLES, new AbstractTablePlanFormatter.LeftJustifiedCell(value.asString()), columns);
                }
                case "incoming topology variables": {
                    return TableScopePlanFormatter.mapping(INCOMING_TOPOLOGY_CONSTANTS, new AbstractTablePlanFormatter.LeftJustifiedCell(value.asString()), columns);
                }
                case "incoming predicate variables": {
                    return TableScopePlanFormatter.mapping(INCOMING_PREDICATE_VARIABLES, new AbstractTablePlanFormatter.LeftJustifiedCell(value.asString()), columns);
                }
                case "incoming path variables": {
                    return TableScopePlanFormatter.mapping(INCOMING_PATH_VARIABLES, new AbstractTablePlanFormatter.LeftJustifiedCell(value.asString()), columns);
                }
                case "referenced": {
                    return TableScopePlanFormatter.mapping(REFERENCED, new AbstractTablePlanFormatter.LeftJustifiedCell(value.asString()), columns);
                }
                case "declared constants": {
                    String valueString = value.asString().trim();
                    if (valueString.isEmpty()) {
                        return Optional.empty();
                    }
                    return TableScopePlanFormatter.mapping(DECLARED_CONSTANTS, new AbstractTablePlanFormatter.LeftJustifiedCell(valueString), columns);
                }
                case "declared variables": {
                    return TableScopePlanFormatter.mapping(DECLARED_VARIABLES, new AbstractTablePlanFormatter.LeftJustifiedCell(value.asString()), columns);
                }
                case "result columns": {
                    return TableScopePlanFormatter.mapping(RESULT_COLUMNS, new AbstractTablePlanFormatter.LeftJustifiedCell(value.asString()), columns);
                }
                case "outgoing constants": {
                    String valueString = value.asString().trim();
                    if (valueString.isEmpty()) {
                        return Optional.empty();
                    }
                    return TableScopePlanFormatter.mapping(OUTGOING_CONSTANTS, new AbstractTablePlanFormatter.LeftJustifiedCell(value.asString()), columns);
                }
                case "outgoing variables": {
                    return TableScopePlanFormatter.mapping(OUTGOING_VARIABLES, new AbstractTablePlanFormatter.LeftJustifiedCell(value.asString()), columns);
                }
            }
            return Optional.empty();
        });
        return formattedPlan.filter(Optional::isPresent).collect(Collectors.toMap(o -> (String)((AbstractTablePlanFormatter.Pair)o.get())._1, o -> (AbstractTablePlanFormatter.Cell)((AbstractTablePlanFormatter.Pair)o.get())._2));
    }

    private static Optional<AbstractTablePlanFormatter.Pair<String, AbstractTablePlanFormatter.Cell>> mapping(String key, AbstractTablePlanFormatter.Cell value, Map<String, Integer> columns) {
        TableScopePlanFormatter.update(columns, key, value.length);
        return Optional.of(AbstractTablePlanFormatter.Pair.of(key, value));
    }

    private static void update(Map<String, Integer> columns, String key, int length) {
        columns.put(key, Math.max(columns.getOrDefault(key, 0), length));
    }

    @Override
    protected AbstractTablePlanFormatter.Level rootLevel() {
        return new Root();
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    static class Root
    extends AbstractTablePlanFormatter.Level {
        Root() {
        }

        @Override
        AbstractTablePlanFormatter.Level sibling() {
            throw new IllegalStateException("root level has no sibling");
        }

        @Override
        AbstractTablePlanFormatter.Level lastSibling() {
            throw new IllegalStateException("root level has no sibling");
        }

        @Override
        AbstractTablePlanFormatter.Level firstChild() {
            BitSet childLastOnLevels = new BitSet();
            childLastOnLevels.set(0, true);
            childLastOnLevels.set(1, false);
            return new Fork(1, childLastOnLevels);
        }

        @Override
        AbstractTablePlanFormatter.Level onlyChild() {
            BitSet childLastOnLevels = new BitSet();
            childLastOnLevels.set(0, true);
            childLastOnLevels.set(1, true);
            return new Fork(1, childLastOnLevels);
        }

        @Override
        String line() {
            return "+";
        }

        @Override
        Optional<String> connector() {
            return Optional.empty();
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    static class Fork
    extends AbstractTablePlanFormatter.Level {
        private final int level;
        private final BitSet lastOnLevels;

        Fork(int level, BitSet lastOnLevels) {
            this.level = level;
            this.lastOnLevels = lastOnLevels;
        }

        @Override
        AbstractTablePlanFormatter.Level sibling() {
            return new Child(this.level, this.lastOnLevels);
        }

        @Override
        AbstractTablePlanFormatter.Level lastSibling() {
            BitSet childLastOnLevels = (BitSet)this.lastOnLevels.clone();
            childLastOnLevels.set(this.level, true);
            return new Child(this.level, childLastOnLevels);
        }

        @Override
        AbstractTablePlanFormatter.Level firstChild() {
            BitSet childLastOnLevels = (BitSet)this.lastOnLevels.clone();
            childLastOnLevels.set(this.level + 1, false);
            return new Fork(this.level + 1, childLastOnLevels);
        }

        @Override
        AbstractTablePlanFormatter.Level onlyChild() {
            BitSet childLastOnLevels = (BitSet)this.lastOnLevels.clone();
            childLastOnLevels.set(this.level + 1, true);
            return new Fork(this.level + 1, childLastOnLevels);
        }

        @Override
        String line() {
            return OutputFormatter.repeatConditionally("  ", "| ", this.level, this.lastOnLevels::get) + "+";
        }

        @Override
        Optional<String> connector() {
            return Optional.of(OutputFormatter.repeatConditionally("  ", "| ", this.level - 1, this.lastOnLevels::get) + (this.lastOnLevels.get(this.level - 1) ? " \\" : "|\\"));
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    static class Child
    extends AbstractTablePlanFormatter.Level {
        private final int level;
        private final BitSet lastOnLevels;

        Child(int level, BitSet lastOnLevels) {
            this.level = level;
            this.lastOnLevels = lastOnLevels;
        }

        @Override
        AbstractTablePlanFormatter.Level sibling() {
            return new Child(this.level, this.lastOnLevels);
        }

        @Override
        AbstractTablePlanFormatter.Level lastSibling() {
            BitSet childLastOnLevels = (BitSet)this.lastOnLevels.clone();
            childLastOnLevels.set(this.level, true);
            return new Child(this.level, childLastOnLevels);
        }

        @Override
        AbstractTablePlanFormatter.Level firstChild() {
            BitSet childLastOnLevels = (BitSet)this.lastOnLevels.clone();
            childLastOnLevels.set(this.level + 1, false);
            return new Fork(this.level + 1, childLastOnLevels);
        }

        @Override
        AbstractTablePlanFormatter.Level onlyChild() {
            BitSet childLastOnLevels = (BitSet)this.lastOnLevels.clone();
            childLastOnLevels.set(this.level + 1, true);
            return new Fork(this.level + 1, childLastOnLevels);
        }

        @Override
        String line() {
            return OutputFormatter.repeatConditionally("  ", "| ", this.level, this.lastOnLevels::get) + "+";
        }

        @Override
        Optional<String> connector() {
            return Optional.of(OutputFormatter.repeatConditionally("  ", "| ", this.level, this.lastOnLevels::get) + "|");
        }
    }
}

