/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shell.commands;

import java.util.List;
import java.util.Optional;
import net.sourceforge.argparse4j.ArgumentParsers;
import net.sourceforge.argparse4j.inf.ArgumentParser;
import net.sourceforge.argparse4j.inf.ArgumentParserException;
import net.sourceforge.argparse4j.inf.Namespace;
import org.neo4j.shell.CypherShell;
import org.neo4j.shell.Environment;
import org.neo4j.shell.commands.Command;
import org.neo4j.shell.exception.CommandException;
import org.neo4j.shell.exception.ExitException;
import org.neo4j.shell.exception.NoMoreInputException;
import org.neo4j.shell.exception.UserInterruptException;
import org.neo4j.shell.terminal.CypherShellTerminal;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class Connect
implements Command {
    private final CypherShell shell;
    private final CypherShellTerminal terminal;
    private final ArgumentParser argumentParser;
    private final Environment environment;

    public Connect(CypherShell shell, CypherShellTerminal terminal, Environment environment) {
        this.shell = shell;
        this.terminal = terminal;
        this.argumentParser = this.setupParser();
        this.environment = environment;
    }

    @Override
    public void execute(List<String> args) throws ExitException, CommandException {
        if (this.shell.isConnected()) {
            throw new CommandException("Already connected");
        }
        this.connect(args);
    }

    private void connect(List<String> stringArgs) throws CommandException {
        this.requireArgumentCount(stringArgs, 0, 6);
        try {
            Namespace args = this.argumentParser.parseArgs(stringArgs.toArray(new String[0]));
            String user = args.getString("username");
            String password = args.getString("password");
            if (user == null && password != null) {
                throw new CommandException("You cannot provide password only, please provide a username using '-u USERNAME'");
            }
            if (user == null) {
                user = this.promptForNonEmptyText("username", false);
                password = this.promptForText("password", true);
            } else if (password == null) {
                password = this.promptForText("password", true);
            }
            this.shell.connect(user, password, this.database(args));
        }
        catch (ArgumentParserException e) {
            throw new CommandException(String.format("Invalid input string: '%s', usage: ':connect %s'", String.join((CharSequence)" ", stringArgs), this.metadata().usage()));
        }
    }

    private ArgumentParser setupParser() {
        ArgumentParser parser = ArgumentParsers.newFor((String)this.metadata().name()).build();
        parser.addArgument(new String[]{"-d", "--database"});
        parser.addArgument(new String[]{"-u", "--username"});
        parser.addArgument(new String[]{"-p", "--password"});
        return parser;
    }

    private String promptForNonEmptyText(String prompt, boolean mask) throws CommandException {
        String text = this.promptForText(prompt, mask);
        if (!text.isEmpty()) {
            return text;
        }
        this.terminal.write().println(prompt + " cannot be empty");
        this.terminal.write().println();
        return this.promptForNonEmptyText(prompt, mask);
    }

    private String promptForText(String prompt, boolean mask) throws CommandException {
        try {
            return this.terminal.read().simplePrompt(prompt + ": ", mask);
        }
        catch (NoMoreInputException | UserInterruptException e) {
            throw new CommandException("No text could be read, exiting...");
        }
    }

    private String database(Namespace ns) {
        return Optional.ofNullable(ns.getString("database")).or(() -> Optional.ofNullable(this.environment.getVariable("NEO4J_DATABASE"))).orElse("");
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static class Factory
    implements Command.Factory {
        @Override
        public Command.Metadata metadata() {
            String usage = "[-u USERNAME, --username USERNAME], [-p PASSWORD, --password PASSWORD], [-d DATABASE, --database DATABASE]";
            String help = String.format(":connect %s, connects to a database", usage);
            return new Command.Metadata(":connect", "Connects to a database", usage, help, List.of());
        }

        @Override
        public Command executor(Command.Factory.Arguments args) {
            return new Connect(args.cypherShell(), args.terminal(), new Environment());
        }
    }
}

