/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shell.util;

import java.util.Optional;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public record Version(int major, int minor, int patch, Optional<Integer> preRelease) implements Comparable<Version>
{
    public Version(int major, int minor, int patch) {
        this(major, minor, patch, Optional.empty());
    }

    @Override
    public int compareTo(Version o) {
        int comp = Integer.compare(this.major, o.major);
        if (comp == 0 && (comp = Integer.compare(this.minor, o.minor)) == 0 && (comp = Integer.compare(this.patch, o.patch)) == 0) {
            comp = this.preRelease.isEmpty() ? (o.preRelease.isEmpty() ? 0 : -1) : (o.preRelease.isEmpty() ? 1 : Integer.compare(this.preRelease.get(), o.preRelease.get()));
        }
        return comp;
    }

    @Override
    public String toString() {
        if (this.preRelease.isPresent()) {
            return String.format("%d.%d.%d-%d", this.major, this.minor, this.patch, this.preRelease);
        }
        return String.format("%d.%d.%d", this.major, this.minor, this.patch);
    }

    public String majorMinorString() {
        return String.format("%d.%d", this.major, this.minor);
    }
}

