/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shell.parser;

import java.io.IOException;
import java.io.Reader;
import java.util.List;
import java.util.Optional;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public interface StatementParser {
    public ParsedStatements parse(Reader var1) throws IOException;

    public ParsedStatements parse(String var1) throws IOException;

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public record CypherStatement(String statement, boolean isComplete, int beginOffset, int endOffset) implements ParsedStatement
    {
        public static CypherStatement complete(String statement) {
            return new CypherStatement(statement, true, 0, statement.isEmpty() ? 0 : statement.length() - 1);
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public record CommandStatement(String name, List<String> args, boolean isComplete, int beginOffset, int endOffset) implements ParsedStatement
    {
        @Override
        public String statement() {
            return this.name + " " + String.join((CharSequence)" ", this.args);
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static sealed interface ParsedStatement
    permits CommandStatement, CypherStatement {
        public String statement();

        public int beginOffset();

        public int endOffset();

        public boolean isComplete();
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public record ParsedStatements(List<ParsedStatement> statements) {
        public boolean isEmpty() {
            return this.statements.isEmpty();
        }

        public boolean hasIncompleteStatement() {
            if (this.statements.isEmpty()) {
                return false;
            }
            return !this.statements.get(this.statements.size() - 1).isComplete();
        }

        public Optional<ParsedStatement> statementAtOffset(int offset) {
            for (int i = this.statements.size() - 1; i >= 0; --i) {
                ParsedStatement statement = this.statements.get(i);
                if ((statement.isComplete() || offset < statement.beginOffset()) && (offset < statement.beginOffset() || offset > statement.endOffset() + 1)) continue;
                return Optional.of(statement);
            }
            return Optional.empty();
        }
    }
}

