/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shell.completions;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.neo4j.driver.Record;
import org.neo4j.shell.log.Logger;
import org.neo4j.shell.state.BoltResult;
import org.neo4j.shell.state.BoltStateHandler;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class QueryPoller
implements AutoCloseable {
    private static final Logger log = Logger.create();
    private final ScheduledExecutorService poller = Executors.newSingleThreadScheduledExecutor();
    private ScheduledFuture<?> pollingThread;
    Runnable pollingWorkload;
    private static final int ITEM_LIMIT = 1000;
    private final BoltStateHandler boltStateHandler;
    public static final String FETCH_DATA_SUMMARY = "CALL db.labels() YIELD label\n" + String.format("RETURN COLLECT(label)[..%s] AS result\n", 1000) + "UNION ALL\nCALL db.relationshipTypes() YIELD relationshipType\n" + String.format("RETURN COLLECT(relationshipType)[..%s] AS result\n", 1000) + "UNION ALL\nCALL db.propertyKeys() YIELD propertyKey\n" + String.format("RETURN COLLECT(propertyKey)[..%s] AS result", 1000);
    public static final String FETCH_PROCEDURES = "SHOW PROCEDURES YIELD name, returnDescription";
    public static final String FETCH_FUNCTIONS = "SHOW FUNCTIONS YIELD name";
    public static final String FETCH_DATABASES = "SHOW DATABASES YIELD name, aliases;";
    public static final String FETCH_ROLES = "SHOW ROLES YIELD role;";
    public static final String FETCH_USERS = "SHOW USERS YIELD user;";

    public QueryPoller(BoltStateHandler boltStateHandler) {
        this.boltStateHandler = boltStateHandler;
    }

    @Override
    public void close() throws Exception {
        this.pollingThread.cancel(true);
        this.poller.shutdown();
    }

    public void startPolling(PollingQuery ... queries) {
        this.pollingWorkload = () -> {
            for (PollingQuery q : queries) {
                try {
                    Optional<BoltResult> result;
                    if (this.boltStateHandler == null || !this.boltStateHandler.isConnected() || !(result = this.boltStateHandler.runServiceCypher(q.query, Map.of())).isPresent()) continue;
                    List<Record> records = result.get().getRecords();
                    q.onFetch.accept(records);
                }
                catch (Exception e) {
                    log.warn("Failed to fetch auto completion metadata with query: " + q.query, e);
                }
            }
        };
        this.pollingThread = this.poller.scheduleWithFixedDelay(this.pollingWorkload, 5L, 30L, TimeUnit.SECONDS);
    }

    public void resumePolling() {
        if (this.pollingWorkload != null && this.pollingThread == null) {
            this.pollingThread = this.poller.scheduleWithFixedDelay(this.pollingWorkload, 5L, 30L, TimeUnit.SECONDS);
        }
    }

    public void stopPolling() {
        if (this.pollingThread != null) {
            this.pollingThread.cancel(false);
            this.pollingThread = null;
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public record PollingQuery(String query, Consumer<List<Record>> onFetch) {
    }
}

