/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.test;

import java.util.HashMap;
import java.util.Map;
import org.assertj.core.api.LongAssert;
import org.assertj.core.api.SoftAssertions;
import org.neo4j.io.pagecache.monitoring.PageCacheCounters;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorCounters;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.storageengine.api.StorageEngineFactory;
import org.neo4j.util.Preconditions;

public class PageCacheTracerAssertions {
    public static TracingBuilder assertThatTracing(GraphDatabaseAPI db) {
        return new TracingBuilder(((StorageEngineFactory)db.getDependencyResolver().resolveDependency(StorageEngineFactory.class)).name());
    }

    public static PerStorageEngine pins(long pins) {
        return new PerStorageEngine(pins);
    }

    public static class TracingBuilder {
        private final String storageEngineName;
        private final Map<String, PerStorageEngine> perStorage = new HashMap<String, PerStorageEngine>();

        private TracingBuilder(String storageEngineName) {
            this.storageEngineName = storageEngineName;
        }

        public TracingBuilder record(PerStorageEngine storageEngineNumbers) {
            return this.storageEngine("record", storageEngineNumbers);
        }

        public TracingBuilder freki(PerStorageEngine storageEngineNumbers) {
            return this.storageEngine("freki", storageEngineNumbers);
        }

        public TracingBuilder storageEngine(String name, PerStorageEngine storageEngineNumbers) {
            this.perStorage.put(name, storageEngineNumbers);
            return this;
        }

        public void matches(PageCacheCounters pageCacheTracer) {
            this.forCorrectStorageEngine().assertMatches(pageCacheTracer);
        }

        public void matches(PageCursorCounters pageCursorTracer) {
            this.forCorrectStorageEngine().assertMatches(pageCursorTracer);
        }

        private PerStorageEngine forCorrectStorageEngine() {
            PerStorageEngine numbers = this.perStorage.get(this.storageEngineName);
            Preconditions.checkState((numbers != null ? 1 : 0) != 0, (String)"No page cache tracer numbers specified for storage engine '%s'", (Object[])new Object[]{this.storageEngineName});
            return numbers;
        }
    }

    public static class PerStorageEngine {
        private final long pins;
        private long upperBoundPins;
        private boolean overlookUnpins;
        private Long faults;

        private PerStorageEngine(long pins) {
            this.pins = pins;
            this.atMost(pins);
        }

        public PerStorageEngine atMost(long upperBoundPins) {
            this.upperBoundPins = upperBoundPins;
            Preconditions.checkState((upperBoundPins >= this.pins ? 1 : 0) != 0, (String)"Should be larger than pins");
            return this;
        }

        public PerStorageEngine skipUnpins() {
            this.overlookUnpins = true;
            return this;
        }

        public PerStorageEngine faults(long faults) {
            this.faults = faults;
            return this;
        }

        public PerStorageEngine noFaults() {
            this.faults = 0L;
            return this;
        }

        private void assertMatches(PageCacheCounters tracer) {
            this.assertMatches(tracer.pins(), tracer.unpins(), tracer.hits(), tracer.faults());
        }

        private void assertMatches(PageCursorCounters tracer) {
            this.assertMatches(tracer.pins(), tracer.unpins(), tracer.hits(), tracer.faults());
        }

        private void assertMatches(long tracedPins, long tracedUnpins, long tracedHits, long tracedFaults) {
            SoftAssertions softly = new SoftAssertions();
            ((LongAssert)softly.assertThat(tracedPins).as("pins", new Object[0])).isBetween(Long.valueOf(this.pins), Long.valueOf(this.upperBoundPins));
            if (!this.overlookUnpins) {
                ((LongAssert)softly.assertThat(tracedUnpins).as("unpins", new Object[0])).isBetween(Long.valueOf(this.pins), Long.valueOf(this.upperBoundPins));
            }
            if (this.faults != null) {
                ((LongAssert)softly.assertThat(tracedFaults).as("faults", new Object[0])).isEqualTo((Object)this.faults);
                ((LongAssert)softly.assertThat(tracedHits).as("hits", new Object[0])).isBetween(Long.valueOf(this.pins - this.faults), Long.valueOf(this.upperBoundPins - this.faults));
            }
            softly.assertAll();
        }
    }
}

