/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.procedure;

import java.io.IOException;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.neo4j.collection.ResourceRawIterator;
import org.neo4j.exceptions.KernelException;
import org.neo4j.function.ThrowingFunction;
import org.neo4j.graphdb.Transaction;
import org.neo4j.internal.kernel.api.exceptions.ProcedureException;
import org.neo4j.internal.kernel.api.procs.Neo4jTypes;
import org.neo4j.internal.kernel.api.procs.ProcedureHandle;
import org.neo4j.internal.kernel.api.procs.ProcedureSignature;
import org.neo4j.internal.kernel.api.procs.QualifiedName;
import org.neo4j.internal.kernel.api.procs.UserAggregationReducer;
import org.neo4j.internal.kernel.api.procs.UserFunctionHandle;
import org.neo4j.internal.kernel.api.procs.UserFunctionSignature;
import org.neo4j.kernel.api.QueryLanguage;
import org.neo4j.kernel.api.ResourceMonitor;
import org.neo4j.kernel.api.procedure.CallableProcedure;
import org.neo4j.kernel.api.procedure.CallableUserAggregationFunction;
import org.neo4j.kernel.api.procedure.CallableUserFunction;
import org.neo4j.kernel.api.procedure.Context;
import org.neo4j.kernel.api.procedure.GlobalProcedures;
import org.neo4j.kernel.api.procedure.ProcedureView;
import org.neo4j.values.AnyValue;

public class LazyProcedures
implements GlobalProcedures,
Consumer<Supplier<GlobalProcedures>> {
    private Supplier<GlobalProcedures> initializer;
    private volatile GlobalProcedures globalProcedures;
    private final LazyProcedureView lazyProcedureView = new LazyProcedureView();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init() {
        if (this.globalProcedures != null) {
            return;
        }
        LazyProcedures lazyProcedures = this;
        synchronized (lazyProcedures) {
            if (this.globalProcedures == null) {
                Objects.requireNonNull(this.initializer);
                this.globalProcedures = this.initializer.get();
            }
        }
    }

    public void register(CallableProcedure proc) throws ProcedureException {
        this.init();
        this.globalProcedures.register(proc);
    }

    public void register(CallableUserFunction function) throws ProcedureException {
        this.init();
        this.globalProcedures.register(function);
    }

    public void register(CallableUserAggregationFunction function) throws ProcedureException {
        this.init();
        this.globalProcedures.register(function);
    }

    public void registerProcedure(Class<?> proc) throws ProcedureException {
        this.init();
        this.globalProcedures.registerProcedure(proc);
    }

    public void registerFunction(Class<?> func) throws ProcedureException {
        this.init();
        this.globalProcedures.registerFunction(func);
    }

    public void registerAggregationFunction(Class<?> func) throws ProcedureException {
        this.init();
        this.globalProcedures.registerAggregationFunction(func);
    }

    public void registerType(Class<?> javaClass, Neo4jTypes.AnyType type) {
        this.init();
        this.globalProcedures.registerType(javaClass, type);
    }

    public <T> void registerComponent(Class<T> cls, ThrowingFunction<Context, T, ProcedureException> provider, boolean safe) {
        this.init();
        this.globalProcedures.registerComponent(cls, provider, safe);
    }

    public void unregister(QualifiedName name) {
        GlobalProcedures procedures = this.globalProcedures;
        if (procedures != null) {
            procedures.unregister(name);
        }
    }

    @Override
    public void accept(Supplier<GlobalProcedures> procedureSupplier) {
        Objects.requireNonNull(procedureSupplier);
        if (this.initializer != null) {
            throw new IllegalStateException("Lazy procedures already have initializer: " + String.valueOf(this.initializer));
        }
        this.initializer = procedureSupplier;
    }

    public ProcedureView getCurrentView() {
        if (this.globalProcedures == null) {
            return this.lazyProcedureView;
        }
        return this.globalProcedures.getCurrentView();
    }

    public GlobalProcedures.LoadInformation reloadProceduresFromDisk(Transaction tx, Predicate<String> namespaceFilter) throws KernelException, IOException {
        this.init();
        return this.globalProcedures.reloadProceduresFromDisk(tx, namespaceFilter);
    }

    private class LazyProcedureView
    implements ProcedureView {
        private volatile ProcedureView view;

        private LazyProcedureView() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void initView() {
            if (this.view != null) {
                return;
            }
            LazyProcedureView lazyProcedureView = this;
            synchronized (lazyProcedureView) {
                if (this.view == null) {
                    LazyProcedures.this.init();
                    this.view = LazyProcedures.this.globalProcedures.getCurrentView();
                }
            }
        }

        public ProcedureHandle procedure(QualifiedName name, QueryLanguage scope) throws ProcedureException {
            this.initView();
            return this.view.procedure(name, scope);
        }

        public UserFunctionHandle function(QualifiedName name, QueryLanguage scope) {
            this.initView();
            return this.view.function(name, scope);
        }

        public UserFunctionHandle aggregationFunction(QualifiedName name, QueryLanguage scope) {
            this.initView();
            return this.view.aggregationFunction(name, scope);
        }

        public Stream<ProcedureSignature> getAllProcedures(QueryLanguage scope) {
            this.initView();
            return this.view.getAllProcedures(scope);
        }

        public Stream<UserFunctionSignature> getAllNonAggregatingFunctions(QueryLanguage scope) {
            this.initView();
            return this.view.getAllNonAggregatingFunctions(scope);
        }

        public Stream<UserFunctionSignature> getAllAggregatingFunctions(QueryLanguage scope) {
            this.initView();
            return this.view.getAllAggregatingFunctions(scope);
        }

        public ResourceRawIterator<AnyValue[], ProcedureException> callProcedure(Context ctx, int id, AnyValue[] input, ResourceMonitor resourceMonitor) throws ProcedureException {
            this.initView();
            return this.view.callProcedure(ctx, id, input, resourceMonitor);
        }

        public AnyValue callFunction(Context ctx, int id, AnyValue[] input) throws ProcedureException {
            this.initView();
            return this.view.callFunction(ctx, id, input);
        }

        public UserAggregationReducer createAggregationFunction(Context ctx, int id) throws ProcedureException {
            this.initView();
            return this.view.createAggregationFunction(ctx, id);
        }

        public <T> ThrowingFunction<Context, T, ProcedureException> lookupComponentProvider(Class<T> cls, boolean safe) {
            this.initView();
            return this.view.lookupComponentProvider(cls, safe);
        }

        public int[] getProcedureIds(String procedureGlobbing) {
            this.initView();
            return this.view.getProcedureIds(procedureGlobbing);
        }

        public int[] getAdminProcedureIds() {
            this.initView();
            return this.view.getAdminProcedureIds();
        }

        public int[] getFunctionIds(String functionGlobbing) {
            this.initView();
            return this.view.getFunctionIds(functionGlobbing);
        }

        public int[] getAggregatingFunctionIds(String functionGlobbing) {
            this.initView();
            return this.view.getAggregatingFunctionIds(functionGlobbing);
        }

        public long signatureVersion() {
            if (this.view == null) {
                return -1L;
            }
            return this.view.signatureVersion();
        }
    }
}

