/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.test.limited;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Set;
import org.neo4j.io.fs.DelegatingFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.StoreChannel;
import org.neo4j.memory.EmptyMemoryTracker;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.test.impl.ChannelInputStream;
import org.neo4j.test.impl.ChannelOutputStream;
import org.neo4j.test.limited.LimitedFileChannel;

public class LimitedFilesystemAbstraction
extends DelegatingFileSystemAbstraction {
    private volatile boolean outOfSpace;

    public LimitedFilesystemAbstraction(FileSystemAbstraction delegate) {
        super(delegate);
    }

    public StoreChannel open(Path fileName, Set<OpenOption> options) throws IOException {
        return new LimitedFileChannel(super.open(fileName, options), this);
    }

    public OutputStream openAsOutputStream(Path fileName, boolean append) throws IOException {
        return new ChannelOutputStream(this.write(fileName), append, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
    }

    public InputStream openAsInputStream(Path fileName) throws IOException {
        return new ChannelInputStream(this.read(fileName), (MemoryTracker)EmptyMemoryTracker.INSTANCE);
    }

    public Reader openAsReader(Path fileName, Charset charset) throws IOException {
        return new InputStreamReader(this.openAsInputStream(fileName), charset);
    }

    public Writer openAsWriter(Path fileName, Charset charset, boolean append) throws IOException {
        return new OutputStreamWriter(this.openAsOutputStream(fileName, append), StandardCharsets.UTF_8);
    }

    public StoreChannel write(Path fileName) throws IOException {
        this.ensureHasSpace();
        return new LimitedFileChannel(super.write(fileName), this);
    }

    public void mkdirs(Path fileName) throws IOException {
        this.ensureHasSpace();
        super.mkdirs(fileName);
    }

    public void renameFile(Path from, Path to, CopyOption ... copyOptions) throws IOException {
        this.ensureHasSpace();
        super.renameFile(from, to, copyOptions);
    }

    public void runOutOfDiskSpace(boolean outOfSpace) {
        this.outOfSpace = outOfSpace;
    }

    public void ensureHasSpace() throws IOException {
        if (this.outOfSpace) {
            throw new IOException("No space left on device");
        }
    }
}

