/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.test.limited;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.neo4j.io.fs.DelegatingStoreChannel;
import org.neo4j.io.fs.StoreChannel;
import org.neo4j.test.limited.LimitedFilesystemAbstraction;

public class LimitedFileChannel
extends DelegatingStoreChannel
implements StoreChannel {
    private final LimitedFilesystemAbstraction fs;

    public LimitedFileChannel(StoreChannel inner, LimitedFilesystemAbstraction limitedFilesystemAbstraction) {
        super(inner);
        this.fs = limitedFilesystemAbstraction;
    }

    public int write(ByteBuffer byteBuffer) throws IOException {
        this.fs.ensureHasSpace();
        return super.write(byteBuffer);
    }

    public long write(ByteBuffer[] byteBuffers, int offset, int length) throws IOException {
        this.fs.ensureHasSpace();
        return super.write(byteBuffers, offset, length);
    }

    public long write(ByteBuffer[] srcs) throws IOException {
        this.fs.ensureHasSpace();
        return super.write(srcs);
    }

    public LimitedFileChannel position(long newPosition) throws IOException {
        super.position(newPosition);
        return this;
    }

    public LimitedFileChannel truncate(long size) throws IOException {
        super.truncate(size);
        return this;
    }

    public void force(boolean metaData) throws IOException {
        this.fs.ensureHasSpace();
        super.force(metaData);
    }

    public void writeAll(ByteBuffer src, long position) throws IOException {
        this.fs.ensureHasSpace();
        super.writeAll(src, position);
    }

    public void writeAll(ByteBuffer src) throws IOException {
        this.fs.ensureHasSpace();
        super.writeAll(src);
    }
}

