/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.snapshot;

import java.util.Objects;
import java.util.function.Function;
import java.util.function.LongSupplier;
import org.neo4j.io.pagecache.context.VersionContext;
import org.neo4j.io.pagecache.context.VersionContextSupplier;
import org.neo4j.kernel.impl.context.TransactionVersionContextSupplier;
import org.neo4j.snapshot.TestVersionContext;

public class TestTransactionVersionContextSupplier
extends TransactionVersionContextSupplier {
    private final Function<String, TestVersionContext> supplier;
    private String databaseName;

    public TestTransactionVersionContextSupplier(Function<String, TestVersionContext> supplier) {
        this.supplier = supplier;
    }

    public void init(LongSupplier lastClosedTransactionIdSupplier, String databaseName) {
        super.init(lastClosedTransactionIdSupplier, databaseName);
        this.databaseName = databaseName;
    }

    public VersionContext createVersionContext() {
        String name = this.databaseName;
        Objects.requireNonNull(name);
        TestVersionContext ctx = this.supplier.apply(name);
        return ctx == null ? super.createVersionContext() : ctx;
    }

    public static class Factory
    implements VersionContextSupplier.Factory {
        private volatile Function<String, TestVersionContext> wrappedContextSupplier;

        public void setTestVersionContextSupplier(Function<String, TestVersionContext> wrappedContextSupplier) {
            this.wrappedContextSupplier = wrappedContextSupplier;
        }

        private TestVersionContext getVersionContext(String databaseName) {
            return this.wrappedContextSupplier == null ? null : this.wrappedContextSupplier.apply(databaseName);
        }

        public VersionContextSupplier create() {
            return new TestTransactionVersionContextSupplier(this::getVersionContext);
        }
    }
}

