/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.test.fabric;

import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.neo4j.bolt.dbapi.BoltGraphDatabaseServiceSPI;
import org.neo4j.bolt.dbapi.BoltTransaction;
import org.neo4j.bolt.runtime.AccessMode;
import org.neo4j.bolt.v41.messaging.RoutingContext;
import org.neo4j.configuration.Config;
import org.neo4j.fabric.bolt.BoltFabricDatabaseService;
import org.neo4j.fabric.executor.FabricExecutor;
import org.neo4j.fabric.transaction.FabricTransaction;
import org.neo4j.internal.kernel.api.connectioninfo.ClientConnectionInfo;
import org.neo4j.internal.kernel.api.security.LoginContext;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.impl.coreapi.InternalTransaction;
import org.neo4j.kernel.impl.coreapi.TransactionExceptionMapper;
import org.neo4j.kernel.impl.factory.GraphDatabaseFacade;
import org.neo4j.test.fabric.TestFabricTransaction;

public class TestFabricGraphDatabaseService
extends GraphDatabaseFacade {
    final Supplier<BoltGraphDatabaseServiceSPI> boltFabricDatabaseServiceSupplier;
    final Config config;

    public TestFabricGraphDatabaseService(GraphDatabaseFacade baseDb, Config config, Supplier<BoltGraphDatabaseServiceSPI> boltFabricDatabaseServiceSupplier) {
        super(baseDb, Function.identity());
        this.boltFabricDatabaseServiceSupplier = boltFabricDatabaseServiceSupplier;
        this.config = Objects.requireNonNull(config);
    }

    protected InternalTransaction beginTransactionInternal(KernelTransaction.Type type, LoginContext loginContext, ClientConnectionInfo connectionInfo, long timeoutMillis, Consumer<Status> terminationCallback, TransactionExceptionMapper transactionExceptionMapper) {
        BoltGraphDatabaseServiceSPI databaseService = this.boltFabricDatabaseServiceSupplier.get();
        BoltTransaction boltTransaction = databaseService.beginTransaction(type, loginContext, connectionInfo, List.of(), Duration.ofMillis(timeoutMillis), AccessMode.WRITE, Map.of(), new RoutingContext(false, Map.of()));
        InternalTransaction internalTransaction = this.forceKernelTxCreation(boltTransaction);
        return new TestFabricTransaction(boltTransaction, internalTransaction);
    }

    private InternalTransaction forceKernelTxCreation(BoltTransaction boltTransaction) {
        FabricExecutor fabricExecutor = (FabricExecutor)this.getDependencyResolver().resolveDependency(FabricExecutor.class);
        FabricTransaction fabricTransaction = ((BoltFabricDatabaseService.BoltTransactionImpl)boltTransaction).getFabricTransaction();
        return fabricExecutor.forceKernelTxCreation(fabricTransaction);
    }
}

