/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.test.rule;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.LockSupport;
import java.util.function.Predicate;
import org.neo4j.graphdb.TransientFailureException;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.test.rule.RetryHandler;

public class RetryACoupleOfTimesHandler
implements RetryHandler {
    private final Predicate<Throwable> retriable;
    private final int maxRetryCount;
    private final long timeBetweenTries;
    private final TimeUnit unit;
    private int retries;
    public static final Predicate<Throwable> TRANSIENT_ERRORS = t -> {
        Status status;
        if (t instanceof TransientFailureException) {
            return true;
        }
        return t instanceof Status.HasStatus && (status = ((Status.HasStatus)t).status()).code().classification() == Status.Classification.TransientError;
    };
    public static final Predicate<Throwable> ANY_EXCEPTION = t -> t instanceof Exception;

    public RetryACoupleOfTimesHandler(Predicate<Throwable> retriable) {
        this(retriable, 5, 1L, TimeUnit.SECONDS);
    }

    public RetryACoupleOfTimesHandler(Predicate<Throwable> retriable, int maxRetryCount, long timeBetweenTries, TimeUnit unit) {
        this.retriable = retriable;
        this.maxRetryCount = maxRetryCount;
        this.timeBetweenTries = timeBetweenTries;
        this.unit = unit;
    }

    @Override
    public boolean retryOn(Throwable t) {
        if (this.retriable.test(t)) {
            LockSupport.parkNanos(this.unit.toNanos(this.timeBetweenTries));
            return this.retries++ < this.maxRetryCount;
        }
        return false;
    }

    public static RetryHandler retryACoupleOfTimesOn(Predicate<Throwable> retriable) {
        return new RetryACoupleOfTimesHandler(retriable);
    }

    public static RetryHandler retryACoupleOfTimesOn(Predicate<Throwable> retriable, int maxRetryCount, long timeBetweenTries, TimeUnit unit) {
        return new RetryACoupleOfTimesHandler(retriable, maxRetryCount, timeBetweenTries, unit);
    }
}

