/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.v1.transport.integration;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.junit.rules.ExternalResource;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.mockfs.EphemeralFileSystemAbstraction;
import org.neo4j.helpers.HostnamePort;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.configuration.BoltConnector;
import org.neo4j.kernel.configuration.ConnectorPortRegister;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.test.TestGraphDatabaseFactory;
import org.neo4j.test.rule.TestDirectory;

public class Neo4jWithSocket
extends ExternalResource {
    public static final String DEFAULT_CONNECTOR_KEY = "bolt";
    private Supplier<FileSystemAbstraction> fileSystemProvider;
    private final Consumer<Map<String, String>> configure;
    private final TestDirectory testDirectory;
    private TestGraphDatabaseFactory graphDatabaseFactory;
    private GraphDatabaseService gdb;
    private File workingDirectory;
    private ConnectorPortRegister connectorRegister;

    public Neo4jWithSocket(Class<?> testClass) {
        this(testClass, settings -> {});
    }

    public Neo4jWithSocket(Class<?> testClass, Consumer<Map<String, String>> configure) {
        this(testClass, new TestGraphDatabaseFactory(), configure);
    }

    public Neo4jWithSocket(Class<?> testClass, TestGraphDatabaseFactory graphDatabaseFactory, Consumer<Map<String, String>> configure) {
        this(testClass, graphDatabaseFactory, EphemeralFileSystemAbstraction::new, configure);
    }

    public Neo4jWithSocket(Class<?> testClass, TestGraphDatabaseFactory graphDatabaseFactory, Supplier<FileSystemAbstraction> fileSystemProvider, Consumer<Map<String, String>> configure) {
        this.testDirectory = TestDirectory.testDirectory(testClass, (FileSystemAbstraction)fileSystemProvider.get());
        this.graphDatabaseFactory = graphDatabaseFactory;
        this.fileSystemProvider = fileSystemProvider;
        this.configure = configure;
    }

    public FileSystemAbstraction getFileSystem() {
        return this.graphDatabaseFactory.getFileSystem();
    }

    public File getWorkingDirectory() {
        return this.workingDirectory;
    }

    public Statement apply(final Statement statement, final Description description) {
        Statement testMethod = new Statement(){

            public void evaluate() throws Throwable {
                String name = description.getMethodName() != null ? description.getMethodName() : description.getClassName();
                Neo4jWithSocket.this.workingDirectory = Neo4jWithSocket.this.testDirectory.directory(name);
                Neo4jWithSocket.this.ensureDatabase(settings -> {});
                try {
                    statement.evaluate();
                }
                finally {
                    Neo4jWithSocket.this.shutdownDatabase();
                }
            }
        };
        Statement testMethodWithBeforeAndAfter = super.apply(testMethod, description);
        return this.testDirectory.apply(testMethodWithBeforeAndAfter, description);
    }

    public HostnamePort lookupConnector(String connectorKey) {
        return this.connectorRegister.getLocalAddress(connectorKey);
    }

    public HostnamePort lookupDefaultConnector() {
        return this.connectorRegister.getLocalAddress(DEFAULT_CONNECTOR_KEY);
    }

    public void shutdownDatabase() {
        try {
            if (this.gdb != null) {
                this.gdb.shutdown();
            }
        }
        finally {
            this.connectorRegister = null;
            this.gdb = null;
        }
    }

    public void ensureDatabase(Consumer<Map<String, String>> overrideSettingsFunction) {
        if (this.gdb != null) {
            return;
        }
        Map<String, String> settings = this.configure(overrideSettingsFunction);
        File storeDir = new File(this.workingDirectory, "storeDir");
        this.graphDatabaseFactory.setFileSystem(this.fileSystemProvider.get());
        this.gdb = this.graphDatabaseFactory.newImpermanentDatabaseBuilder(storeDir).setConfig(settings).newGraphDatabase();
        this.connectorRegister = (ConnectorPortRegister)((GraphDatabaseAPI)this.gdb).getDependencyResolver().resolveDependency(ConnectorPortRegister.class);
    }

    private Map<String, String> configure(Consumer<Map<String, String>> overrideSettingsFunction) {
        HashMap<String, String> settings = new HashMap<String, String>();
        settings.put(new BoltConnector((String)DEFAULT_CONNECTOR_KEY).type.name(), "BOLT");
        settings.put(new BoltConnector((String)DEFAULT_CONNECTOR_KEY).enabled.name(), "true");
        settings.put(new BoltConnector((String)DEFAULT_CONNECTOR_KEY).listen_address.name(), "localhost:0");
        settings.put(new BoltConnector((String)DEFAULT_CONNECTOR_KEY).encryption_level.name(), BoltConnector.EncryptionLevel.OPTIONAL.name());
        this.configure.accept(settings);
        overrideSettingsFunction.accept(settings);
        return settings;
    }

    public GraphDatabaseService graphDatabaseService() {
        return this.gdb;
    }
}

