/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.test.rule;

import org.neo4j.graphdb.factory.GraphDatabaseBuilder;
import org.neo4j.graphdb.factory.GraphDatabaseFactory;
import org.neo4j.logging.LogProvider;
import org.neo4j.test.TestGraphDatabaseFactory;
import org.neo4j.test.rule.DatabaseRule;

public class ImpermanentDatabaseRule
extends DatabaseRule {
    private final LogProvider userLogProvider;
    private final LogProvider internalLogProvider;

    public ImpermanentDatabaseRule() {
        this(null);
    }

    public ImpermanentDatabaseRule(LogProvider logProvider) {
        this.userLogProvider = logProvider;
        this.internalLogProvider = logProvider;
    }

    @Override
    public ImpermanentDatabaseRule startLazily() {
        return (ImpermanentDatabaseRule)super.startLazily();
    }

    @Override
    protected GraphDatabaseFactory newFactory() {
        return this.maybeSetInternalLogProvider(this.maybeSetUserLogProvider(new TestGraphDatabaseFactory()));
    }

    @Override
    protected GraphDatabaseBuilder newBuilder(GraphDatabaseFactory factory) {
        return ((TestGraphDatabaseFactory)factory).newImpermanentDatabaseBuilder();
    }

    protected final TestGraphDatabaseFactory maybeSetUserLogProvider(TestGraphDatabaseFactory factory) {
        return this.userLogProvider == null ? factory : factory.setUserLogProvider(this.userLogProvider);
    }

    protected final TestGraphDatabaseFactory maybeSetInternalLogProvider(TestGraphDatabaseFactory factory) {
        return this.internalLogProvider == null ? factory : factory.setInternalLogProvider(this.internalLogProvider);
    }
}

