/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.web;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public enum HttpMethod {
    OPTIONS,
    GET,
    HEAD,
    POST,
    PUT,
    PATCH,
    DELETE,
    TRACE,
    CONNECT;

    private static final Map<String, HttpMethod> methodsByName;

    public static HttpMethod valueOfOrNull(String name) {
        return methodsByName.get(name);
    }

    private static Map<String, HttpMethod> indexMethodsByName() {
        HttpMethod[] methods = HttpMethod.values();
        HashMap<String, HttpMethod> result = new HashMap<String, HttpMethod>(methods.length * 2);
        for (HttpMethod method : methods) {
            result.put(method.name(), method);
        }
        return Collections.unmodifiableMap(result);
    }

    static {
        methodsByName = HttpMethod.indexMethodsByName();
    }
}

