/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.queryapi.driver;

import io.netty.channel.local.LocalAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.time.Clock;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ScheduledExecutorService;
import org.neo4j.bolt.connection.AuthToken;
import org.neo4j.bolt.connection.BoltAgent;
import org.neo4j.bolt.connection.BoltConnection;
import org.neo4j.bolt.connection.BoltConnectionProvider;
import org.neo4j.bolt.connection.BoltProtocolVersion;
import org.neo4j.bolt.connection.LoggingProvider;
import org.neo4j.bolt.connection.NotificationConfig;
import org.neo4j.bolt.connection.SecurityPlan;
import org.neo4j.driver.AuthTokenManager;
import org.neo4j.driver.AuthTokens;
import org.neo4j.driver.Config;
import org.neo4j.driver.Driver;
import org.neo4j.driver.Logging;
import org.neo4j.driver.internal.DriverFactory;
import org.neo4j.driver.internal.security.StaticAuthTokenManager;
import org.neo4j.logging.InternalLogProvider;
import org.neo4j.server.queryapi.driver.DriverToInternalLogProvider;

public final class LocalChannelDriverFactory
extends DriverFactory {
    public static final URI IGNORED_HTTP_DRIVER_URI = URI.create("bolt://http-driver.com:0");
    private final LocalAddress localAddress;
    private final InternalLogProvider internalLogProvider;

    public LocalChannelDriverFactory(LocalAddress localAddress, InternalLogProvider internalLogProvider) {
        this.localAddress = localAddress;
        this.internalLogProvider = internalLogProvider;
    }

    protected LocalAddress localAddress() {
        return this.localAddress;
    }

    protected BoltConnectionProvider createBoltConnectionProvider(ScheduledExecutorService eventLoopGroup, Clock clock, LoggingProvider loggingProvider, int eventLoopThreads) {
        return new BoltConnectionProviderWithRoutingContext(super.createBoltConnectionProvider(eventLoopGroup, clock, loggingProvider, eventLoopThreads));
    }

    public Driver createLocalDriver() {
        return super.newInstance(IGNORED_HTTP_DRIVER_URI, (AuthTokenManager)new StaticAuthTokenManager(AuthTokens.none()), null, Config.builder().withLogging((Logging)new DriverToInternalLogProvider(this.internalLogProvider)).withUserAgent("neo4j-query-api/v2").build());
    }

    private record BoltConnectionProviderWithRoutingContext(BoltConnectionProvider delegate) implements BoltConnectionProvider
    {
        public CompletionStage<BoltConnection> connect(URI uri, String routingContextAddress, BoltAgent boltAgent, String userAgent, int connectTimeoutMillis, SecurityPlan securityPlan, AuthToken authToken, BoltProtocolVersion minVersion, NotificationConfig notificationConfig) {
            try {
                uri = new URI("neo4j", uri.getUserInfo(), uri.getHost(), uri.getPort(), uri.getPath(), uri.getQuery(), uri.getFragment());
            }
            catch (URISyntaxException e) {
                return CompletableFuture.failedStage(e);
            }
            return this.delegate.connect(uri, routingContextAddress, boltAgent, userAgent, connectTimeoutMillis, securityPlan, authToken, minVersion, notificationConfig);
        }

        public CompletionStage<Void> close() {
            return this.delegate.close();
        }
    }
}

