/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.http.cypher.consumer;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.neo4j.bolt.protocol.common.fsm.response.RecordHandler;
import org.neo4j.server.http.cypher.OutputEventStream;
import org.neo4j.server.http.cypher.TransactionIndependentValueMapper;
import org.neo4j.values.AnyValue;
import org.neo4j.values.ValueMapper;

public class OutputEventStreamRecordHandler
implements RecordHandler {
    private final List<String> fieldNames;
    private final OutputEventStream outputEventStream;
    private final Supplier<Map<String, Object>> resultsSupplier;
    private final TransactionIndependentValueMapper valueMapper;
    private Map<String, Object> results;
    private int fieldIndex;

    OutputEventStreamRecordHandler(List<String> fieldNames, OutputEventStream outputEventStream, TransactionIndependentValueMapper valueMapper) {
        this(fieldNames, outputEventStream, valueMapper, HashMap::new);
    }

    protected OutputEventStreamRecordHandler(List<String> fieldNames, OutputEventStream outputEventStream, TransactionIndependentValueMapper valueMapper, Supplier<Map<String, Object>> resultsSupplier) {
        this.fieldNames = fieldNames;
        this.outputEventStream = outputEventStream;
        this.valueMapper = valueMapper;
        this.resultsSupplier = resultsSupplier;
        this.results = resultsSupplier.get();
    }

    public void onBegin() {
        this.fieldIndex = 0;
        this.results = this.resultsSupplier.get();
    }

    public void onField(AnyValue value) {
        this.results.put(this.fieldNames.get(this.fieldIndex++), value.map((ValueMapper)this.valueMapper));
    }

    public void onCompleted() {
        this.outputEventStream.writeRecord(this.fieldNames, this.results::get);
    }

    public void onFailure() {
    }
}

