/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.queryapi.request;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import java.io.IOException;
import java.util.ArrayList;
import org.neo4j.driver.Value;
import org.neo4j.driver.internal.value.ListValue;

public class ListValueDeserializer
extends StdDeserializer<ListValue> {
    public ListValueDeserializer() {
        super(ListValue.class);
    }

    public ListValue deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        ArrayList<Value> valueList = new ArrayList<Value>();
        if (p.isExpectedStartArrayToken()) {
            while (p.nextToken() != JsonToken.END_ARRAY) {
                try {
                    valueList.add((Value)p.readValueAs(Value.class));
                }
                catch (Exception e) {
                    throw new JsonParseException("Unable to read value for list.");
                }
            }
        } else {
            throw new JsonParseException("Expected start array");
        }
        return new ListValue(valueList.toArray(new Value[0]));
    }
}

