/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.web;

import java.nio.file.Path;
import java.util.function.Function;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.RequestLog;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.util.component.AbstractLifeCycle;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.logging.Level;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogTimeZone;
import org.neo4j.logging.log4j.Log4jLogProvider;
import org.neo4j.logging.log4j.LogConfig;
import org.neo4j.logging.log4j.Neo4jLoggerContext;
import org.neo4j.util.concurrent.AsyncEvents;

public class RotatingRequestLog
extends AbstractLifeCycle
implements RequestLog,
AsyncEvents.Monitor {
    private final Log log;
    private final Neo4jLoggerContext loggerContext;

    public RotatingRequestLog(FileSystemAbstraction fs, LogTimeZone logTimeZone, String logFile, long rotationSize, int rotationKeepNumber) {
        this.loggerContext = LogConfig.createBuilder((FileSystemAbstraction)fs, (Path)Path.of(logFile, new String[0]), (Level)Level.INFO).withRotation(rotationSize, rotationKeepNumber).withTimezone(logTimeZone).build();
        this.log = new Log4jLogProvider(this.loggerContext).getLog("REQUEST");
    }

    public void log(Request request, Response response) {
        String remoteHost = RotatingRequestLog.swallowExceptions((HttpServletRequest)request, ServletRequest::getRemoteHost);
        String user = RotatingRequestLog.swallowExceptions((HttpServletRequest)request, HttpServletRequest::getRemoteUser);
        String requestURL = RotatingRequestLog.findRequestURI(request);
        int statusCode = response.getStatus();
        long length = response.getContentLength();
        String referer = RotatingRequestLog.swallowExceptions((HttpServletRequest)request, r -> r.getHeader("Referer"));
        String userAgent = RotatingRequestLog.swallowExceptions((HttpServletRequest)request, r -> r.getHeader("User-Agent"));
        long requestTimeStamp = request != null ? request.getTimeStamp() : -1L;
        long now = System.currentTimeMillis();
        long serviceTime = requestTimeStamp < 0L ? -1L : now - requestTimeStamp;
        this.log.info("%s - %s [%tc] \"%s\" %s %s \"%s\" \"%s\" %s", new Object[]{StringUtils.defaultString((String)remoteHost), StringUtils.defaultString((String)user), now, StringUtils.defaultString((String)requestURL), statusCode, length, StringUtils.defaultString((String)referer), StringUtils.defaultString((String)userAgent), serviceTime});
    }

    private static <T> T swallowExceptions(HttpServletRequest outerRequest, Function<HttpServletRequest, T> function) {
        try {
            return outerRequest == null ? null : (T)function.apply(outerRequest);
        }
        catch (Throwable t) {
            return null;
        }
    }

    protected synchronized void doStop() {
        this.loggerContext.close();
    }

    public void eventCount(long count) {
    }

    private static String findRequestURI(Request request) {
        String requestURI = RotatingRequestLog.swallowExceptions((HttpServletRequest)request, HttpServletRequest::getRequestURI);
        String queryString = RotatingRequestLog.swallowExceptions((HttpServletRequest)request, HttpServletRequest::getQueryString);
        if (queryString == null || queryString.isBlank()) {
            return requestURI;
        }
        return requestURI + "?" + queryString;
    }
}

