/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest.dbms;

import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.neo4j.graphdb.security.AuthorizationViolationException;
import org.neo4j.internal.kernel.api.connectioninfo.ClientConnectionInfo;
import org.neo4j.internal.kernel.api.security.LoginContext;
import org.neo4j.server.rest.dbms.AuthorizationFilter;
import org.neo4j.server.rest.dbms.AuthorizedRequestWrapper;
import org.neo4j.server.rest.web.HttpConnectionInfoFactory;
import org.neo4j.server.web.JettyHttpConnection;

public class AuthorizationDisabledFilter
extends AuthorizationFilter {
    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        AuthorizationDisabledFilter.validateRequestType(servletRequest);
        AuthorizationDisabledFilter.validateResponseType(servletResponse);
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        HttpServletResponse response = (HttpServletResponse)servletResponse;
        try {
            ClientConnectionInfo connectionInfo = HttpConnectionInfoFactory.create(request);
            LoginContext loginContext = this.getAuthDisabledLoginContext(connectionInfo);
            String userAgent = request.getHeader("User-Agent");
            JettyHttpConnection.updateUserForCurrentConnection(loginContext.subject().username(), userAgent);
            filterChain.doFilter((ServletRequest)new AuthorizedRequestWrapper("BASIC", "neo4j", request, loginContext), servletResponse);
        }
        catch (AuthorizationViolationException e) {
            AuthorizationDisabledFilter.unauthorizedAccess(e.getMessage()).accept((Object)response);
        }
    }

    protected LoginContext getAuthDisabledLoginContext(ClientConnectionInfo connectionInfo) {
        return LoginContext.fullAccess((ClientConnectionInfo)connectionInfo);
    }
}

